/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.ktde.util.ExceptionHandler;
import org.ktde.util.MultitonManager;

public class ExceptionHandlerFactory
extends MultitonManager<Class<? extends Throwable>, ExceptionHandler> {
    private Map<String, String> knownHandler;

    public ExceptionHandlerFactory(Map<String, String> knownHandler) {
        this.knownHandler = knownHandler;
    }

    public ExceptionHandlerFactory(Properties props) {
        Enumeration<?> names = props.propertyNames();
        this.knownHandler = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("exceptionhandler_")) continue;
            String[] def = props.getProperty(name).split("/");
            this.knownHandler.put(def[0], def[1]);
        }
    }

    @Override
    protected ExceptionHandler createInstance(Class<? extends Throwable> key) {
        String handlername = this.knownHandler.get(key.getName());
        while (handlername == null && key != Throwable.class) {
            Class<? extends Throwable> superkey = key.getSuperclass();
            key = superkey;
            handlername = this.knownHandler.get(key.getName());
        }
        ExceptionHandler handler = null;
        try {
            Class<?> handlerclass = Class.forName(handlername);
            handler = (ExceptionHandler)handlerclass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler;
    }

    @Override
    protected ExceptionHandler createNullInstance() {
        return new ExceptionHandler(){

            @Override
            public boolean handle(Throwable e, Object context) throws Exception {
                return false;
            }
        };
    }
}

