/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.util;

import java.util.concurrent.ConcurrentHashMap;

public class ContextLocal<T> {
    private ThreadLocal<Holder<T>> threadLocal = new ThreadLocal();
    private ConcurrentHashMap<Object, Holder<T>> contexts = new ConcurrentHashMap();

    public void setContextObject(Object context) {
        Holder<Object> current = this.contexts.get(context);
        if (current == null) {
            current = new Holder();
            this.contexts.putIfAbsent(context, current);
            current = this.contexts.get(context);
        }
        this.threadLocal.set(current);
    }

    public void removeContextObject(Object context) {
        this.contexts.remove(context);
    }

    private void assertContextExists() {
        if (this.threadLocal.get() == null) {
            this.setContextObject(Thread.currentThread());
        }
    }

    public T get() {
        this.assertContextExists();
        return (T)((Holder)this.threadLocal.get()).value;
    }

    public void set(T value) {
        this.assertContextExists();
        ((Holder)this.threadLocal.get()).value = value;
    }

    public void remove() {
        this.assertContextExists();
        ((Holder)this.threadLocal.get()).value = null;
    }

    private static class Holder<S> {
        private S value;

        private Holder() {
        }
    }
}

