/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.ImageLoader;
import org.ktde.swing.ImageLoaderListener;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class QuickMapNavigatorRenderer
extends AbstractNavigatorRenderer
implements ImageLoaderListener {
    private Coordinate bl;
    private Coordinate tr;
    private List<Tupel<Tupel<Rectangle, Rectangle>, Image>> images;
    private int maxImages;
    private String quickmap;
    private ImageLoader loader;
    private MediaTracker tracker;

    public QuickMapNavigatorRenderer(String quickmap, int maxImages) {
        super("QuickMapNavigatorRenderer - " + quickmap);
        this.maxImages = maxImages;
        this.quickmap = quickmap;
        this.images = new ArrayList<Tupel<Tupel<Rectangle, Rectangle>, Image>>(maxImages);
    }

    @Override
    protected void setPanel(NavigatorPanel panel) {
        super.setPanel(panel);
        this.tracker = new MediaTracker(panel);
        this.loader = new ImageLoader(this);
    }

    @Override
    public void loadImage() {
        if (this.isActive()) {
            NavigatorPanel navigatorPanel = this.getPanel();
            Point2D.Double blPoint = navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double trPoint = navigatorPanel.getRealBoundaryTopRight();
            if (blPoint == null || trPoint == null) {
                return;
            }
            CoordinateFactory navFactory = navigatorPanel.getCoordinateFactory();
            Coordinate bl = navFactory.createCoordinate(blPoint.getX(), blPoint.getY());
            Coordinate tr = navFactory.createCoordinate(trPoint.getX(), trPoint.getY());
            if (!(bl == null || tr == null || bl.equals(this.bl) && tr.equals(this.tr))) {
                this.bl = bl;
                this.tr = tr;
                int left = (int)Math.floor(bl.getX());
                int top = (int)Math.ceil(tr.getY());
                int right = (int)Math.ceil(tr.getX());
                int bottom = (int)Math.floor(bl.getY());
                AffineTransform transform = navigatorPanel.getTransform();
                double fcosp = transform.getScaleX();
                double fsinp = -transform.getShearX();
                double f = Math.sqrt(Math.pow(fcosp, 2.0) + Math.pow(fsinp, 2.0));
                double cosp = Math.abs(fcosp / f);
                double sinp = Math.abs(fsinp / f);
                double panelw = navigatorPanel.getWidth();
                double panelh = navigatorPanel.getHeight();
                double g = panelh * cosp;
                double h = panelw * sinp;
                double i = panelw * cosp;
                double j = panelh * sinp;
                int imagew = (int)(i + j);
                int imageh = (int)(g + h);
                try {
                    URL url = new URL(this.getUrlForCoords(bl, tr, imagew, imageh, navFactory));
                    if (!this.images.isEmpty()) {
                        this.tracker.removeImage(this.images.get(this.images.size() - 1).getElement2());
                    }
                    if (this.images.size() == this.maxImages) {
                        this.images.remove(0);
                    }
                    Image image = Toolkit.getDefaultToolkit().getImage(url);
                    Rectangle src = new Rectangle(0, 0, imagew, imageh);
                    Rectangle dst = new Rectangle(left, top, right - left, bottom - top);
                    this.images.add(new Tupel<Tupel<Rectangle, Rectangle>, Image>(new Tupel<Rectangle, Rectangle>(src, dst), image));
                    this.tracker.addImage(image, 1);
                    this.tracker.waitForID(1);
                    navigatorPanel.repaint(10L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getUrlForCoords(Coordinate bl, Coordinate tr, int imagew, int imageh, CoordinateFactory factory) {
        int left = (int)Math.floor(bl.getX());
        int top = (int)Math.ceil(tr.getY());
        int right = (int)Math.ceil(tr.getX());
        int bottom = (int)Math.floor(bl.getY());
        return this.quickmap + "?left=" + left + "&right=" + right + "&top=" + top + "&bottom=" + bottom + "&width=" + imagew + "&height=" + imageh;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        this.loader.waitlonger();
        ArrayList<Tupel<Tupel<Rectangle, Rectangle>, Image>> imagesClone = new ArrayList<Tupel<Tupel<Rectangle, Rectangle>, Image>>(this.images);
        for (Tupel<Tupel<Rectangle, Rectangle>, Image> tupel : imagesClone) {
            Rectangle src = tupel.getElement1().getElement1();
            Rectangle dst = tupel.getElement1().getElement2();
            Image image = tupel.getElement2();
            g2d.drawImage(image, dst.x, dst.y, dst.x + dst.width, dst.y + dst.height, src.x, src.y, src.x + src.width, src.y + src.height, null);
        }
        return Collections.emptyList();
    }
}

