/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tripel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmTileQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsmTile.class);
    private int maxQueueDepth = 200;
    private int truncQueueCount = 50;
    private Set<OsmTile> tiles;
    private Map<Tripel<Integer, Integer, Integer>, OsmTile> tileHash = new HashMap<Tripel<Integer, Integer, Integer>, OsmTile>();

    public OsmTileQueue() {
        this.tiles = new LinkedHashSet<OsmTile>();
        this.tileHash = new WeakHashMap<Tripel<Integer, Integer, Integer>, OsmTile>();
    }

    public OsmTile createTile(int x, int y, int z) {
        if (this.tiles.size() >= this.maxQueueDepth) {
            Iterator<OsmTile> iter = this.tiles.iterator();
            for (int i = 0; i < this.truncQueueCount && iter.hasNext(); ++i) {
                OsmTile osmTile = iter.next();
                this.tileHash.remove(osmTile.tripel);
                osmTile.image = null;
                iter.remove();
            }
        }
        long maxMemory = Runtime.getRuntime().maxMemory() / 1000000L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 1000000L;
        long allocMemory = Runtime.getRuntime().totalMemory() / 1000000L;
        long usedMemory = allocMemory - freeMemory;
        long availMemory = maxMemory - usedMemory;
        LOGGER.debug("Queue: " + this.tiles.size() + " Hash: " + this.tileHash.size() + "   free mem:" + freeMemory + "MB   avail mem:" + availMemory + "MB   alloc mem:" + allocMemory + "MB   max mem:" + maxMemory + "MB   used mem:" + usedMemory + "MB");
        Tripel<Integer, Integer, Integer> tripel = new Tripel<Integer, Integer, Integer>(x, y, z);
        OsmTile osmTile = this.tileHash.get(tripel);
        if (osmTile == null) {
            osmTile = new OsmTile(tripel);
            this.tileHash.put(tripel, osmTile);
        }
        return osmTile;
    }

    public void touch(OsmTile tile) {
        this.tiles.remove(tile);
        this.tiles.add(tile);
    }

    static double tile2lon(int x, double z) {
        double n = Math.pow(2.0, z);
        return (double)x / n * 360.0 - 180.0;
    }

    static double tile2lat(int y, double z) {
        double n = Math.pow(2.0, z);
        double lat_rad = Math.atan(Math.sinh(Math.PI * (1.0 - 2.0 * (double)y / n)));
        return Math.toDegrees(lat_rad);
    }

    public class OsmTile {
        private OsmTile parent;
        private Image image;
        private Tripel<Integer, Integer, Integer> tripel;
        private double westWgs;
        private double northWgs;
        private double eastWgs;
        private double southWgs;
        private Coordinate coordNorthWest;
        private Coordinate coordSouthEast;

        private OsmTile(Tripel<Integer, Integer, Integer> tripel) {
            this.tripel = tripel;
            this.image = null;
            int x = this.tripel.getElement1();
            int y = this.tripel.getElement2();
            int z = this.tripel.getElement3();
            this.westWgs = OsmTileQueue.tile2lon(x, z);
            this.northWgs = OsmTileQueue.tile2lat(y, z);
            this.eastWgs = OsmTileQueue.tile2lon(x + 1, z);
            this.southWgs = OsmTileQueue.tile2lat(y + 1, z);
            this.coordNorthWest = Wgs84Factory.INSTANCE.createCoordinate(this.westWgs, this.northWgs);
            this.coordSouthEast = Wgs84Factory.INSTANCE.createCoordinate(this.eastWgs, this.southWgs);
        }

        public Image getImage() {
            return this.image;
        }

        public OsmTile getParent() {
            int z;
            if (this.parent == null && (z = this.tripel.getElement3().intValue()) > 0) {
                int x = this.tripel.getElement1();
                int y = this.tripel.getElement2();
                this.parent = OsmTileQueue.this.createTile(x / 2, y / 2, z - 1);
            }
            return this.parent;
        }

        public Coordinate getCoordNorthWest() {
            return this.coordNorthWest;
        }

        public Coordinate getCoordSouthEast() {
            return this.coordSouthEast;
        }

        public void setImage(Image image) {
            OsmTileQueue.this.touch(this);
            this.image = image;
        }

        public int getZoom() {
            return this.tripel.getElement3();
        }
    }
}

