/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.ImageLoader;
import org.ktde.swing.ImageLoaderListener;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.OsmTileQueue;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmNavigatorRenderer
extends AbstractNavigatorRenderer
implements ImageLoaderListener {
    private static Logger LOGGER = LoggerFactory.getLogger(OsmNavigatorRenderer.class);
    private OsmTileQueue osmTileQueue;
    private ImageLoader loader;
    private MediaTracker tracker;
    private int trackId;
    private int maxZoom = 18;
    private int minZoom = 0;
    private final String defaultRemoteMapHost = "http://tile.openstreetmap.org/%%%z%%%/%%%x%%%/%%%y%%%.png";
    private String mapcacheHost;
    private File localCache;
    private Point2D.Double blPoint;
    private Point2D.Double trPoint;
    private boolean forceReload;

    public OsmNavigatorRenderer(Properties properties) {
        super("OsmNavigatorRenderer");
        String tileServer;
        this.mapcacheHost = properties != null && properties.getProperty("tileserver.maphost") != null ? properties.getProperty("tileserver.maphost") : this.defaultRemoteMapHost;
        if (properties != null && !StringUtil.isBlank(tileServer = properties.getProperty("tileserver.localcache"))) {
            String dirname = properties.getProperty("tileserver.localcache").replaceAll("~", System.getProperty("user.home"));
            this.localCache = new File(dirname);
            if (!this.localCache.exists()) {
                LOGGER.debug("create tile cache dir " + this.localCache.getAbsolutePath());
                if (!this.localCache.mkdirs()) {
                    this.localCache = null;
                }
            }
        }
        this.osmTileQueue = new OsmTileQueue();
        this.forceReload = false;
    }

    @Override
    protected void setPanel(NavigatorPanel panel) {
        super.setPanel(panel);
        this.trackId = 1;
        this.tracker = new MediaTracker(panel);
        this.loader = new ImageLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadImage() {
        if (this.isActive()) {
            NavigatorPanel navigatorPanel = this.getPanel();
            Point2D.Double blPointNow = navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double trPointNow = navigatorPanel.getRealBoundaryTopRight();
            boolean loadImages = false;
            if (this.forceReload || blPointNow != this.blPoint || trPointNow != this.trPoint) {
                loadImages = true;
                this.blPoint = blPointNow;
                this.trPoint = trPointNow;
            }
            block10: while (loadImages) {
                this.forceReload = false;
                loadImages = false;
                if (this.blPoint == null || this.trPoint == null) {
                    return;
                }
                CoordinateFactory navFactory = navigatorPanel.getCoordinateFactory();
                Coordinate bl = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(this.blPoint.getX(), this.blPoint.getY()));
                Coordinate tr = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(this.trPoint.getX(), this.trPoint.getY()));
                int zoom = this.computeZoom(navigatorPanel.getUpp());
                Tripel<Integer, Integer, Integer> helperMin = OsmNavigatorRenderer.getTileNumber(bl.getX(), tr.getY(), zoom);
                Tripel<Integer, Integer, Integer> helperMax = OsmNavigatorRenderer.getTileNumber(tr.getX(), bl.getY(), zoom);
                int mintx = helperMin.getElement2();
                int maxtx = helperMax.getElement2();
                int minty = helperMin.getElement3();
                int maxty = helperMax.getElement3();
                int maxtile = 1 << zoom;
                if (mintx < 0) {
                    mintx = 0;
                }
                if (maxtx >= maxtile) {
                    maxtx = maxtile - 1;
                }
                if (maxtx < mintx) {
                    maxtx = mintx;
                }
                if (minty < 0) {
                    minty = 0;
                }
                if (maxty >= maxtile) {
                    maxty = maxtile - 1;
                }
                if (maxty < minty) {
                    maxty = minty;
                }
                for (int tx = mintx; tx <= maxtx; ++tx) {
                    for (int ty = minty; ty <= maxty; ++ty) {
                        blPointNow = navigatorPanel.getRealBoundaryBottomLeft();
                        trPointNow = navigatorPanel.getRealBoundaryTopRight();
                        if (blPointNow != this.blPoint || trPointNow != this.trPoint) {
                            loadImages = true;
                            this.blPoint = blPointNow;
                            this.trPoint = trPointNow;
                            continue block10;
                        }
                        OsmNavigatorRenderer osmNavigatorRenderer = this;
                        synchronized (osmNavigatorRenderer) {
                            ++this.trackId;
                        }
                        OsmTileQueue.OsmTile tile = this.osmTileQueue.createTile(tx, ty, zoom);
                        if (tile.getImage() != null) continue;
                        try {
                            int imageid;
                            File imageFile;
                            Image image = null;
                            if (this.localCache != null) {
                                File imageFileDir = new File(this.localCache, zoom + "/" + tx);
                                if (!imageFileDir.exists()) {
                                    imageFileDir.mkdirs();
                                }
                                if (!(imageFile = new File(imageFileDir + "/" + ty + ".png")).exists()) {
                                    URL urlhost = new URL(this.mapcacheHost.replaceAll("%%%x%%%", "" + tx).replaceAll("%%%y%%%", "" + ty).replaceAll("%%%z%%%", "" + zoom));
                                    LOGGER.debug("load " + urlhost);
                                    IoUtils.download(urlhost, new FileOutputStream(imageFile));
                                    LOGGER.debug("loaded " + urlhost);
                                }
                                image = Toolkit.getDefaultToolkit().getImage(imageFile.getAbsolutePath());
                            } else {
                                URL urlhost = new URL(this.mapcacheHost.replaceAll("%%%x%%%", "" + tx).replaceAll("%%%y%%%", "" + ty).replaceAll("%%%z%%%", "" + zoom));
                                LOGGER.debug("load " + urlhost);
                                image = Toolkit.getDefaultToolkit().getImage(urlhost);
                            }
                            this.tracker.addImage(image, imageid);
                            try {
                                this.tracker.waitForID(imageid, 2000L);
                                boolean b = this.tracker.isErrorID(imageid);
                                if (b) {
                                    if (this.localCache != null && (imageFile = new File(this.localCache, zoom + "/" + tx + "/" + ty + ".png")).exists()) {
                                        LOGGER.error("delete corrupt " + imageFile);
                                        imageFile.delete();
                                    }
                                    continue;
                                }
                                tile.setImage(image);
                                navigatorPanel.repaint(100L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                this.forceReload = true;
                                continue;
                            }
                            finally {
                                this.tracker.removeImage(image, imageid);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                loadImages |= this.forceReload;
            }
        }
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        this.loader.waitlonger();
        NavigatorPanel navigatorPanel = this.getPanel();
        Point2D.Double blPoint = navigatorPanel.getRealBoundaryBottomLeft();
        Point2D.Double trPoint = navigatorPanel.getRealBoundaryTopRight();
        CoordinateFactory navFactory = navigatorPanel.getCoordinateFactory();
        Coordinate bl = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(blPoint.getX(), blPoint.getY()));
        Coordinate tr = Wgs84Factory.INSTANCE.createCoordinate(navFactory.createCoordinate(trPoint.getX(), trPoint.getY()));
        int zoom = this.computeZoom(upp);
        Tripel<Integer, Integer, Integer> helperMin = OsmNavigatorRenderer.getTileNumber(bl.getX(), tr.getY(), zoom);
        Tripel<Integer, Integer, Integer> helperMax = OsmNavigatorRenderer.getTileNumber(tr.getX(), bl.getY(), zoom);
        int mintx = helperMin.getElement2();
        int maxtx = helperMax.getElement2();
        int minty = helperMin.getElement3();
        int maxty = helperMax.getElement3();
        HashMap<Integer, HashSet<OsmTileQueue.OsmTile>> todraw = new HashMap<Integer, HashSet<OsmTileQueue.OsmTile>>();
        TreeSet<Integer> zoomlevels = new TreeSet<Integer>();
        for (int tx = mintx; tx <= maxtx; ++tx) {
            for (int ty = minty; ty <= maxty; ++ty) {
                OsmTileQueue.OsmTile tile = this.osmTileQueue.createTile(tx, ty, zoom);
                Image image = tile.getImage();
                int MAX_ZOOM_DELTA = 10;
                for (int check = 0; check < MAX_ZOOM_DELTA && image == null; ++check) {
                    this.forceReload = true;
                    OsmTileQueue.OsmTile parent = tile.getParent();
                    if (parent == null) break;
                    tile = parent;
                    image = tile.getImage();
                }
                if (image == null) continue;
                int knownzoom = tile.getZoom();
                zoomlevels.add(knownzoom);
                HashSet<OsmTileQueue.OsmTile> list = (HashSet<OsmTileQueue.OsmTile>)todraw.get(knownzoom);
                if (list == null) {
                    list = new HashSet<OsmTileQueue.OsmTile>();
                    todraw.put(knownzoom, list);
                }
                list.add(tile);
            }
        }
        for (Integer zoomlevel : zoomlevels) {
            for (OsmTileQueue.OsmTile tile : (Set)todraw.get(zoomlevel)) {
                this.osmTileQueue.touch(tile);
                Image image = tile.getImage();
                Coordinate nwNav = navFactory.createCoordinate(tile.getCoordNorthWest());
                Coordinate seNav = navFactory.createCoordinate(tile.getCoordSouthEast());
                g2d.drawImage(image, (int)nwNav.getX(), (int)nwNav.getY(), (int)seNav.getX(), (int)seNav.getY(), 0, 0, 256, 256, null);
                LOGGER.trace("g2d.drawImage(image, " + (int)nwNav.getX() + ", " + (int)nwNav.getY() + ", " + (int)seNav.getX() + ", " + (int)seNav.getY() + ", 0, 0, 256, 256, null);");
            }
        }
        return Collections.emptyList();
    }

    public static Tripel<Integer, Integer, Integer> getTileNumber(double lon, double lat, int zoom) {
        int maxtile = 1 << zoom;
        int xtile = (int)Math.floor((lon + 180.0) / 360.0 * (double)maxtile);
        int ytile = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)maxtile);
        return new Tripel<Integer, Integer, Integer>(zoom, xtile, ytile);
    }

    private int computeZoom(double upp) {
        double upp0 = 140625.0;
        double zoomD = Math.log(upp0 / upp) / Math.log(2.0);
        int zoom = Math.min(Math.max((int)zoomD, this.minZoom), this.maxZoom);
        return zoom;
    }
}

