/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import org.ktde.swing.navigator.AbstractMouseManipulatorAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;

public class NavigatorRotateAction
extends AbstractMouseManipulatorAction {
    private static final long serialVersionUID = 6332625961608961742L;
    private Point2D.Double mouseDown;
    private Point2D.Double mouseAnchor;
    private boolean mouseMoving;
    private double lastRotation;
    private double startRotation;
    private Cursor panningUp;
    private Cursor panningDown;

    public NavigatorRotateAction(NavigatorPanel navigatorPanel) {
        super(navigatorPanel, null, "Rotate");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/handopen.png"));
        this.panningUp = toolkit.createCustomCursor(image, new Point(16, 16), "img");
        image = toolkit.getImage(NavigatorPanel.class.getResource("/cursor/handclosed.png"));
        this.panningDown = toolkit.createCustomCursor(image, new Point(16, 16), "img");
    }

    @Override
    protected void turnedOff() {
        this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    protected void turnedOn() {
        this.getNavigatorPanel().setCursor(this.panningUp);
    }

    @Override
    public void mouseDragged(int x, int y) {
        Point2D.Double newMouseAnchor = new Point2D.Double(x, y);
        if (this.mouseMoving) {
            if (newMouseAnchor.distance(this.mouseDown) > 3.0) {
                if (this.mouseAnchor.distance(this.mouseDown) < 3.0) {
                    this.mouseAnchor = newMouseAnchor;
                } else {
                    this.startRotation = Math.atan2(this.mouseAnchor.y - this.mouseDown.y, this.mouseAnchor.x - this.mouseDown.x);
                    this.lastRotation = 0.0;
                    double newAngle = Math.atan2(newMouseAnchor.y - this.mouseDown.y, newMouseAnchor.x - this.mouseDown.x);
                    double dist = Math.abs(this.startRotation - newAngle);
                    if (dist > 0.05) {
                        this.mouseMoving = false;
                    }
                }
            }
        } else {
            double newRotation = Math.atan2(newMouseAnchor.y - this.mouseDown.y, newMouseAnchor.x - this.mouseDown.x);
            double toRotate = newRotation - this.startRotation - this.lastRotation;
            this.lastRotation = newRotation - this.startRotation;
            this.getNavigatorPanel().rotate(toRotate, this.mouseDown);
        }
    }

    @Override
    public void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
        this.mouseAnchor = this.mouseDown = new Point2D.Double(x, y);
        this.mouseMoving = true;
        this.getNavigatorPanel().setCursor(this.panningDown);
    }

    @Override
    public void mouseDragFinished(int x, int y, int modifiers) {
        this.mouseDown = null;
        this.getNavigatorPanel().setCursor(this.panningUp);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseMoved(int x, int y) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

