/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.Timer;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.MouseManipulator;

public class DefaultMouseManipulator
implements MouseManipulator {
    private Timer timer;
    protected boolean dragged;
    private int clickCount;
    protected MouseEvent pressedMouseEvent;

    public DefaultMouseManipulator() {
        Integer multiclickInterval = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (multiclickInterval == null) {
            multiclickInterval = 500;
        }
        this.timer = new Timer(multiclickInterval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DefaultMouseManipulator.this.pressedMouseEvent == null) {
                    return;
                }
                int x = DefaultMouseManipulator.this.pressedMouseEvent.getX();
                int y = DefaultMouseManipulator.this.pressedMouseEvent.getY();
                int modifiers = DefaultMouseManipulator.this.pressedMouseEvent.getModifiers();
                MouseButton mouseButton = MouseButton.getMouseButton(DefaultMouseManipulator.this.pressedMouseEvent);
                DefaultMouseManipulator.this.mouseClickFinished(x, y, DefaultMouseManipulator.this.clickCount, modifiers, mouseButton);
                DefaultMouseManipulator.this.clickCount = 0;
                DefaultMouseManipulator.this.pressedMouseEvent = null;
            }
        });
        this.timer.setRepeats(false);
    }

    public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragged = true;
        if (this.pressedMouseEvent == null) {
            this.pressedMouseEvent = e;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.timer.stop();
        this.pressedMouseEvent = e;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed()) {
            if (this.dragged) {
                this.dragged = false;
                this.pressedMouseEvent = null;
            } else {
                ++this.clickCount;
                this.timer.start();
            }
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }
}

