/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.navigator;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.Timer;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.MouseManipulator;
import org.ktde.swing.navigator.NavigatorPanel;

public abstract class AbstractMouseManipulatorAction
extends AbstractToggleAction
implements MouseManipulator {
    private static final long serialVersionUID = -3679803189859555486L;
    private static final int PIXELS_TO_BE_DRAGGED = 3;
    private final NavigatorPanel navigatorPanel;
    private boolean dragged;
    private int clickCount;
    private Timer timer;
    private MouseEvent pressedMouseEvent;
    private Double maxUpp;
    private boolean turnedOn;

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp) {
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, boolean on) {
        super(title, on);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon icon, boolean on) {
        super(icon, on);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon iconOn, Icon iconOff, boolean on) {
        super(iconOn, iconOff, on);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon iconOn, Icon iconOff) {
        super(iconOn, iconOff);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, Icon icon) {
        super(icon);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, Icon icon, boolean on) {
        super(title, icon, on);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title, Icon icon) {
        super(title, icon);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, boolean on) {
        super(titleOn, titleOff, on);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, Icon iconOn, Icon iconOff, boolean on) {
        super(titleOn, titleOff, iconOn, iconOff, on);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff, Icon iconOn, Icon iconOff) {
        super(titleOn, titleOff, iconOn, iconOff);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String titleOn, String titleOff) {
        super(titleOn, titleOff);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    public AbstractMouseManipulatorAction(NavigatorPanel navigatorPanel, Double maxUpp, String title) {
        super(title);
        this.navigatorPanel = navigatorPanel;
        this.maxUpp = maxUpp;
        this.initializeTimer();
    }

    private void initializeTimer() {
        Integer multiclickInterval = this.getTimerInterval();
        this.timer = new Timer(multiclickInterval, new TimerActionListener());
        this.timer.setRepeats(false);
    }

    protected Integer getTimerInterval() {
        Integer m = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        return m == null ? 500 : m;
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (!this.checkUpp()) {
            return;
        }
        this.dragged = true;
        MouseEvent mouseEvent = this.pressedMouseEvent == null ? e : this.pressedMouseEvent;
        double distance = Math.sqrt(Math.pow(e.getX() - mouseEvent.getX(), 2.0) + Math.pow(e.getY() - mouseEvent.getY(), 2.0));
        if (distance >= 3.0) {
            this.mouseDragged(e.getX(), e.getY());
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        if (!this.checkUpp()) {
            return;
        }
        if (this.pressedMouseEvent != null) {
            this.mouseReleased(e);
        }
        this.mouseMoved(e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.timer.stop();
        if (!this.checkUpp()) {
            return;
        }
        this.pressedMouseEvent = e;
        this.mousePressed(e.getX(), e.getY(), e.getModifiersEx(), MouseButton.getMouseButton(e));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed()) {
            if (this.dragged) {
                this.mouseDragFinished(e.getX(), e.getY(), e.getModifiers());
                this.clickCount = 0;
                this.dragged = false;
                this.pressedMouseEvent = null;
                this.mouseMoved(e.getX(), e.getY());
            } else {
                ++this.clickCount;
                this.timer.start();
            }
            e.consume();
        }
    }

    @Override
    public final void turnOff() {
        if (this.navigatorPanel.unsetMouseManipulator(this)) {
            this.turnedOff();
        }
        this.turnedOn = false;
    }

    @Override
    public final void turnOn() {
        this.navigatorPanel.setMouseManipulator(this);
        this.turnedOn();
        this.turnedOn = true;
    }

    public final void setTurnedOn(boolean turnedOn) {
        if (turnedOn) {
            this.turnOn();
        } else {
            this.turnOff();
        }
    }

    public boolean isTurnedOn() {
        return this.turnedOn;
    }

    protected abstract void turnedOn();

    protected abstract void turnedOff();

    protected abstract void mousePressed(int var1, int var2, int var3, MouseButton var4);

    protected abstract void mouseDragged(int var1, int var2);

    protected abstract void mouseDragFinished(int var1, int var2, int var3);

    protected abstract void mouseClicked(int var1, int var2, int var3, int var4, MouseButton var5);

    protected abstract void mouseMoved(int var1, int var2);

    protected boolean checkUpp() {
        return this.maxUpp == null || this.maxUpp >= this.navigatorPanel.getScaledUpp();
    }

    protected void setMaxUpp(Double maxUpp) {
        this.maxUpp = maxUpp;
    }

    protected NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    protected Coordinate createCoordinateForPixel(int x, int y) {
        Point2D.Double point = this.navigatorPanel.getReal(new Point2D.Double(x, y));
        return this.navigatorPanel.getCoordinateFactory().createCoordinate(point.x, point.y);
    }

    private class TimerActionListener
    implements ActionListener {
        private TimerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractMouseManipulatorAction.this.pressedMouseEvent == null) {
                return;
            }
            int x = AbstractMouseManipulatorAction.this.pressedMouseEvent.getX();
            int y = AbstractMouseManipulatorAction.this.pressedMouseEvent.getY();
            int modifiers = AbstractMouseManipulatorAction.this.pressedMouseEvent.getModifiers();
            MouseButton mouseButton = MouseButton.getMouseButton(AbstractMouseManipulatorAction.this.pressedMouseEvent);
            AbstractMouseManipulatorAction.this.mouseClicked(x, y, AbstractMouseManipulatorAction.this.clickCount, modifiers, mouseButton);
            AbstractMouseManipulatorAction.this.clickCount = 0;
            AbstractMouseManipulatorAction.this.pressedMouseEvent = null;
            AbstractMouseManipulatorAction.this.mouseMoved(x, y);
        }
    }
}

