/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.graphics;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.ktde.swing.graphics.Polygon2D;

public class PolyRing
implements Shape {
    private Area area;
    private Vector<Polygon2D> adds = new Vector();
    private Vector<Polygon2D> subs = new Vector();

    public PolyRing() {
        this.area = new Area();
    }

    private static Polygon2D createPoly(double[] pointsx, double[] pointsy) throws IndexOutOfBoundsException {
        if (pointsx.length != pointsy.length) {
            throw new IndexOutOfBoundsException("More " + (pointsx.length < pointsy.length ? "Y" : "X") + " Coordinates than " + (pointsx.length < pointsy.length ? "X" : "Y"));
        }
        Polygon2D.Double p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(pointsx[0], pointsy[0]);
        for (int i = 1; i < pointsx.length; ++i) {
            ((Polygon2D)p).lineTo(pointsx[i], pointsy[i]);
        }
        ((Polygon2D)p).closePath();
        return p;
    }

    private void add(Polygon2D add) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.adds.addElement(add);
        this.recalculateArea();
    }

    public void add(double[] pointsx, double[] pointsy) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.add(PolyRing.createPoly(pointsx, pointsy));
    }

    private void sub(Polygon2D sub) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.subs.addElement(sub);
        this.recalculateArea();
    }

    public void sub(double[] pointsx, double[] pointsy) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.sub(PolyRing.createPoly(pointsx, pointsy));
    }

    public void insert(Polygon2D poly) {
        if (this.adds.size() > 0) {
            boolean extClockwise = this.adds.elementAt(0).isClockwise();
            if (poly.isClockwise() == extClockwise) {
                this.add(poly);
            } else {
                this.sub(poly);
            }
        } else {
            this.add(poly);
        }
    }

    public void recalculateArea() {
        Area a;
        int i;
        this.area = new Area();
        for (i = 0; i < this.adds.size(); ++i) {
            a = new Area(this.adds.elementAt(i));
            this.area.add(a);
        }
        for (i = 0; i < this.subs.size(); ++i) {
            a = new Area(this.subs.elementAt(i));
            this.area.subtract(a);
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.area.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.area.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.area.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.area.getPathIterator(at, flatness);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.area.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.area.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.area.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.area.contains(r);
    }

    public void intersect(Area rhs) {
        this.area.intersect(rhs);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.area.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.area.intersects(r);
    }

    public static void writeToStream(PolyRing ring1, ObjectOutputStream out) throws IOException {
        int j;
        Polygon2D p;
        int i;
        if (ring1 == null) {
            out.writeObject(null);
            return;
        }
        out.writeObject("org.ktde.awt.geom.PolyRing");
        out.writeInt(11);
        out.writeInt(ring1.adds.size());
        for (i = 0; i < ring1.adds.size(); ++i) {
            p = ring1.adds.elementAt(i);
            out.writeInt(p.getVertexCount());
            for (j = 0; j < p.getVertexCount(); ++j) {
                out.writeDouble(p.getX(j));
                out.writeDouble(p.getY(j));
            }
        }
        out.writeInt(ring1.subs.size());
        for (i = 0; i < ring1.subs.size(); ++i) {
            p = ring1.subs.elementAt(i);
            out.writeInt(p.getVertexCount());
            for (j = 0; j < p.getVertexCount(); ++j) {
                out.writeDouble(p.getX(j));
                out.writeDouble(p.getY(j));
            }
        }
    }

    public static PolyRing readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int j;
        Polygon2D.Double p;
        int pl;
        int i;
        PolyRing ring1 = new PolyRing();
        String classname = (String)in.readObject();
        if (classname == null) {
            return null;
        }
        if (!classname.equals("org.ktde.awt.geom.PolyRing")) {
            throw new ClassNotFoundException("Wrong class " + classname + ", org.ktde.awt.geom.PolyRing expected");
        }
        int version = in.readInt();
        if (version != 11) {
            throw new ClassNotFoundException("Unknown class version org.ktde.awt.geom.PolyRing v" + version / 100 + "." + version / 10 % 10 + (version % 10 == 0 ? "" : "" + (char)(97 + version % 10 - 1)));
        }
        int l = in.readInt();
        for (i = 0; i < l; ++i) {
            pl = in.readInt();
            p = new Polygon2D.Double();
            ((Polygon2D)p).moveTo(in.readDouble(), in.readDouble());
            for (j = 1; j < pl; ++j) {
                ((Polygon2D)p).lineTo(in.readDouble(), in.readDouble());
            }
            ((Polygon2D)p).closePath();
            ring1.adds.addElement(p);
        }
        l = in.readInt();
        for (i = 0; i < l; ++i) {
            pl = in.readInt();
            p = new Polygon2D.Double();
            ((Polygon2D)p).moveTo(in.readDouble(), in.readDouble());
            for (j = 1; j < pl; ++j) {
                ((Polygon2D)p).lineTo(in.readDouble(), in.readDouble());
            }
            ((Polygon2D)p).closePath();
            ring1.subs.addElement(p);
        }
        ring1.recalculateArea();
        return ring1;
    }

    public String toString() {
        int j;
        Polygon2D p;
        int i;
        String s = "PolyRing: \n";
        if (this.area.isEmpty()) {
            s = s + "Empty";
            return s;
        }
        s = s + "Adds " + this.adds.size() + "Polys\n";
        for (i = 0; i < this.adds.size(); ++i) {
            s = s + "\t";
            p = this.adds.elementAt(i);
            for (j = 0; j < p.getVertexCount(); ++j) {
                if (j > 0) {
                    s = s + ", ";
                }
                s = s + "(" + p.getX(j) + ", " + p.getY(j) + ")";
            }
            s = s + "\n";
        }
        s = s + "Subs " + this.subs.size() + "Polys\n";
        for (i = 0; i < this.subs.size(); ++i) {
            s = s + "\t";
            p = this.subs.elementAt(i);
            for (j = 0; j < p.getVertexCount(); ++j) {
                if (j > 0) {
                    s = s + ", ";
                }
                s = s + "(" + p.getX(j) + ", " + p.getY(j) + ")";
            }
            s = s + "\n";
        }
        return s;
    }

    public static double ringMinDistance(PolyRing ring1, PolyRing ring2) {
        if (PolyRing.ringCrossing(ring1, ring2)) {
            return 0.0;
        }
        double minDist = 1.0 + Math.sqrt(Math.pow(ring1.adds.elementAt(0).getX(0) - ring2.adds.elementAt(0).getX(0), 2.0) + Math.pow(ring1.adds.elementAt(0).getY(0) - ring2.adds.elementAt(0).getY(0), 2.0));
        for (int i = 0; i < ring1.adds.size() + ring1.subs.size(); ++i) {
            Polygon2D p1 = i < ring1.adds.size() ? ring1.adds.elementAt(i) : ring1.subs.elementAt(i - ring1.adds.size());
            for (int j = 0; j < ring2.adds.size() + ring2.subs.size(); ++j) {
                Polygon2D p2 = j < ring2.adds.size() ? ring2.adds.elementAt(j) : ring2.subs.elementAt(j - ring2.adds.size());
                for (int i1 = 0; i1 < p1.getVertexCount(); ++i1) {
                    Line2D.Double lin1 = new Line2D.Double(p1.getX(i1), p1.getY(i1), p1.getX((i1 + 1) % p1.getVertexCount()), p1.getY((i1 + 1) % p1.getVertexCount()));
                    for (int i2 = 0; i2 < p2.getVertexCount(); ++i2) {
                        Line2D.Double lin2 = new Line2D.Double(p2.getX(i2), p2.getY(i2), p2.getX((i2 + 1) % p2.getVertexCount()), p2.getY((i2 + 1) % p2.getVertexCount()));
                        if (lin1.intersectsLine(lin2)) {
                            return 0.0;
                        }
                        double dist = lin1.ptSegDist(((Line2D)lin2).getP1());
                        if (dist < minDist) {
                            minDist = dist;
                        }
                        if ((dist = lin1.ptSegDist(((Line2D)lin2).getP2())) < minDist) {
                            minDist = dist;
                        }
                        if ((dist = lin2.ptSegDist(((Line2D)lin1).getP1())) < minDist) {
                            minDist = dist;
                        }
                        if (!((dist = lin2.ptSegDist(((Line2D)lin1).getP2())) < minDist)) continue;
                        minDist = dist;
                    }
                }
            }
        }
        return minDist;
    }

    public static Line2D ringMinDistanceLine(PolyRing ring1, PolyRing ring2) {
        if (PolyRing.ringCrossing(ring1, ring2)) {
            return null;
        }
        double minDist = 1.0 + Math.sqrt(Math.pow(ring1.adds.elementAt(0).getX(0) - ring2.adds.elementAt(0).getX(0), 2.0) + Math.pow(ring1.adds.elementAt(0).getY(0) - ring2.adds.elementAt(0).getY(0), 2.0));
        double minx1 = 0.0;
        double miny1 = 0.0;
        double minx2 = 0.0;
        double miny2 = 0.0;
        double minx3 = 0.0;
        double miny3 = 0.0;
        for (int i = 0; i < ring1.adds.size() + ring1.subs.size(); ++i) {
            Polygon2D p1 = i < ring1.adds.size() ? ring1.adds.elementAt(i) : ring1.subs.elementAt(i - ring1.adds.size());
            for (int j = 0; j < ring2.adds.size() + ring2.subs.size(); ++j) {
                Polygon2D p2 = j < ring2.adds.size() ? ring2.adds.elementAt(j) : ring2.subs.elementAt(j - ring2.adds.size());
                for (int i1 = 0; i1 < p1.getVertexCount(); ++i1) {
                    Line2D.Double lin1 = new Line2D.Double(p1.getX(i1), p1.getY(i1), p1.getX((i1 + 1) % p1.getVertexCount()), p1.getY((i1 + 1) % p1.getVertexCount()));
                    for (int i2 = 0; i2 < p2.getVertexCount(); ++i2) {
                        Line2D.Double lin2 = new Line2D.Double(p2.getX(i2), p2.getY(i2), p2.getX((i2 + 1) % p2.getVertexCount()), p2.getY((i2 + 1) % p2.getVertexCount()));
                        if (lin1.intersectsLine(lin2)) {
                            return null;
                        }
                        double dist = lin1.ptSegDist(((Line2D)lin2).getP1());
                        if (dist < minDist) {
                            minDist = dist;
                            minx1 = ((Line2D)lin1).getX1();
                            miny1 = ((Line2D)lin1).getY1();
                            minx2 = ((Line2D)lin1).getX2();
                            miny2 = ((Line2D)lin1).getY2();
                            minx3 = ((Line2D)lin2).getX1();
                            miny3 = ((Line2D)lin2).getY1();
                        }
                        if ((dist = lin1.ptSegDist(((Line2D)lin2).getP2())) < minDist) {
                            minDist = dist;
                            minx1 = ((Line2D)lin1).getX1();
                            miny1 = ((Line2D)lin1).getY1();
                            minx2 = ((Line2D)lin1).getX2();
                            miny2 = ((Line2D)lin1).getY2();
                            minx3 = ((Line2D)lin2).getX2();
                            miny3 = ((Line2D)lin2).getY2();
                        }
                        if ((dist = lin2.ptSegDist(((Line2D)lin1).getP1())) < minDist) {
                            minDist = dist;
                            minx1 = ((Line2D)lin2).getX1();
                            miny1 = ((Line2D)lin2).getY1();
                            minx2 = ((Line2D)lin2).getX2();
                            miny2 = ((Line2D)lin2).getY2();
                            minx3 = ((Line2D)lin1).getX1();
                            miny3 = ((Line2D)lin1).getY1();
                        }
                        if (!((dist = lin2.ptSegDist(((Line2D)lin1).getP2())) < minDist)) continue;
                        minDist = dist;
                        minx1 = ((Line2D)lin2).getX1();
                        miny1 = ((Line2D)lin2).getY1();
                        minx2 = ((Line2D)lin2).getX2();
                        miny2 = ((Line2D)lin2).getY2();
                        minx3 = ((Line2D)lin1).getX2();
                        miny3 = ((Line2D)lin1).getY2();
                    }
                }
            }
        }
        return new Line2D.Double(new Point2D.Double(minx3, miny3), PolyRing.normalCrossingPoint(new Line2D.Double(minx1, miny1, minx2, miny2), new Point2D.Double(minx3, miny3)));
    }

    public static boolean ringCrossing(PolyRing ring1, PolyRing ring2) {
        for (int i = 0; i < ring1.adds.size() + ring1.subs.size(); ++i) {
            Polygon2D poly1 = i < ring1.adds.size() ? ring1.adds.elementAt(i) : ring1.subs.elementAt(i - ring1.adds.size());
            for (int j = 0; j < ring2.adds.size() + ring2.subs.size(); ++j) {
                Polygon2D poly2;
                Polygon2D polygon2D = poly2 = j < ring2.adds.size() ? ring2.adds.elementAt(j) : ring2.subs.elementAt(j - ring2.adds.size());
                if (!PolyRing.polyCrossing(poly1, poly2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean polyCrossing(Polygon2D poly1, Polygon2D poly2) {
        for (int i = 0; i < poly1.getVertexCount(); ++i) {
            Line2D.Double line2 = new Line2D.Double(poly1.getX(i), poly1.getY(i), poly1.getX((i + 1) % poly1.getVertexCount()), poly1.getY((i + 1) % poly1.getVertexCount()));
            if (!PolyRing.polyCrossing(poly2, line2)) continue;
            return true;
        }
        return false;
    }

    public static boolean polyCrossing(Polygon2D poly, Line2D line) {
        for (int i = 0; i < poly.getVertexCount(); ++i) {
            Line2D.Double line2 = new Line2D.Double(poly.getX(i), poly.getY(i), poly.getX((i + 1) % poly.getVertexCount()), poly.getY((i + 1) % poly.getVertexCount()));
            if (!PolyRing.lineCrossing(line, line2)) continue;
            return true;
        }
        return false;
    }

    public static boolean lineCrossing(Line2D line1, Line2D line2) {
        return PolyRing.lineCrossingPoint(line1, line2) != null;
    }

    public static Point2D lineCrossingPoint(Line2D line1, Line2D line2) {
        double y;
        double x;
        double x11 = line1.getX1();
        double y11 = line1.getY1();
        double x12 = line1.getX2();
        double y12 = line1.getY2();
        double x21 = line2.getX1();
        double y21 = line2.getY1();
        double x22 = line2.getX2();
        double y22 = line2.getY2();
        if (x12 - x11 == 0.0 && x22 - x21 == 0.0) {
            double y2;
            if (x11 != x21) {
                return null;
            }
            double x2 = x12;
            if (y11 > Math.min(y21, y22) && y11 < Math.max(y21, y22)) {
                y2 = y11;
            } else if (y12 > Math.min(y21, y22) && y12 < Math.max(y21, y22)) {
                y2 = y12;
            } else if (y21 > Math.min(y11, y12) && y21 < Math.max(y11, y12)) {
                y2 = y21;
            } else if (y22 > Math.min(y11, y12) && y22 < Math.max(y11, y12)) {
                y2 = y22;
            } else {
                return null;
            }
            return new Point2D.Double(x2, y2);
        }
        if (x12 - x11 == 0.0) {
            double m2 = (y22 - y21) / (x22 - x21);
            double t2 = y21 - m2 * x21;
            x = x11;
            y = m2 * x + t2;
        } else if (x22 - x21 == 0.0) {
            double m1 = (y12 - y11) / (x12 - x11);
            double t1 = y11 - m1 * x11;
            x = x21;
            y = m1 * x + t1;
        } else {
            double m1 = (y12 - y11) / (x12 - x11);
            double t1 = y11 - m1 * x11;
            double m2 = (y22 - y21) / (x22 - x21);
            double t2 = y21 - m2 * x21;
            x = (t2 - t1) / (m1 - m2);
            y = m1 * x + t1;
        }
        if (x < Math.max(x11, x12) && x > Math.min(x11, x12) && x < Math.max(x21, x22) && x > Math.min(x21, x22) && y < Math.max(y11, y12) && y > Math.min(y11, y12) && y < Math.max(y21, y22) && y > Math.min(y21, y22)) {
            return new Point2D.Double(x, y);
        }
        return null;
    }

    public static Point2D normalCrossingPoint(Line2D line, Point2D point) {
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        double x3 = point.getX();
        double y3 = point.getY();
        if (y1 == y2) {
            if (x3 < Math.min(x1, x2)) {
                return new Point2D.Double(Math.min(x1, x2), y1);
            }
            if (x3 > Math.max(x1, x2)) {
                return new Point2D.Double(Math.max(x1, x2), y1);
            }
            return new Point2D.Double(x3, y1);
        }
        if (x1 == x2) {
            if (y3 < Math.min(y1, y2)) {
                return new Point2D.Double(x1, Math.min(y1, y2));
            }
            if (y3 > Math.max(y1, y2)) {
                return new Point2D.Double(x1, Math.max(y1, y2));
            }
            return new Point2D.Double(x1, y3);
        }
        double m1 = (y2 - y1) / (x2 - x1);
        double m2 = -1.0 / m1;
        double t2 = y3 - m2 * x3;
        double t1 = y1 - m1 * x1;
        double x = (t2 - t1) / (m1 - m2);
        if (x < Math.min(x1, x2)) {
            x = Math.min(x1, x2);
        }
        if (x > Math.max(x1, x2)) {
            x = Math.max(x1, x2);
        }
        double y = m1 * x + t1;
        return new Point2D.Double(x, y);
    }
}

