/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing.algorithm;

import java.awt.Component;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.ktde.swing.algorithm.AlgorithmProgressMonitor;
import org.ktde.util.algorithm.Algorithm;
import org.ktde.util.algorithm.AlgorithmStepEvent;

public class ChainedAlgorithmProgressMonitor
extends AlgorithmProgressMonitor {
    private Map<Object, Integer> totalSteps = new IdentityHashMap<Object, Integer>();
    private Map<Object, Integer> progressedStepCounts = new IdentityHashMap<Object, Integer>();
    private int totalCount = 0;
    private int totalProgress;

    public ChainedAlgorithmProgressMonitor(Component parentComponent, Object message, Collection<Algorithm> algorithms) {
        super(parentComponent, message);
        for (Algorithm algorithm : algorithms) {
            int pre = algorithm.preCalcSteps();
            this.totalSteps.put(algorithm, pre);
            this.totalCount += pre;
        }
        this.totalProgress = 0;
    }

    @Override
    public void algorithmStepPerformed(AlgorithmStepEvent event) {
        Object source = event.getSource();
        Integer formerStepsTotal = this.totalSteps.get(source);
        if (formerStepsTotal == null) {
            formerStepsTotal = 0;
        }
        int stepsTotal = event.getStepsTotal();
        this.totalCount += stepsTotal - formerStepsTotal;
        this.setMaximum(this.totalCount);
        this.totalSteps.put(source, stepsTotal);
        Integer formerProgressedCount = this.progressedStepCounts.get(source);
        if (formerProgressedCount == null) {
            formerProgressedCount = 0;
        }
        int progressed = stepsTotal - event.getStepsLeft();
        this.totalProgress += progressed - formerProgressedCount;
        this.setProgress(this.totalProgress);
        this.progressedStepCounts.put(source, progressed);
        this.setNote(event.getNote());
    }
}

