/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.swing.ToggleAction;

public class ToggleGroup
implements VetoableChangeListener {
    private List<ToggleAction> actions;
    private ToggleAction selected;

    public ToggleGroup() {
        this.actions = new ArrayList<ToggleAction>();
    }

    public ToggleGroup(ToggleAction ... action) {
        this.actions = new ArrayList<ToggleAction>(action.length);
        for (ToggleAction toggleAction : action) {
            this.addAction(toggleAction);
        }
    }

    public ToggleGroup(Collection<ToggleAction> actions2) {
        this.actions = new ArrayList<ToggleAction>(actions2);
    }

    public void addAction(ToggleAction action) {
        boolean selected = action.isSelected();
        if (this.selected != null && selected) {
            action.setSelected(false);
        }
        this.actions.add(action);
        action.addVetoableChangeListener(this);
    }

    public Collection<ToggleAction> getActions() {
        return Collections.unmodifiableCollection(this.actions);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        Object source;
        if (e.getPropertyName() == "SwingSelectedKey" && this.actions.contains(source = e.getSource())) {
            ToggleAction sourceAction = (ToggleAction)source;
            if (source == this.selected) {
                throw new PropertyVetoException("cannot deselect in group", e);
            }
            if (this.selected != null) {
                ToggleAction oldAction = this.selected;
                this.selected = null;
                oldAction.setSelected(false);
            }
            this.selected = sourceAction;
        }
    }
}

