/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelGroupPlacer {
    public static void createGroup(Container panel, JComponent[] components, String[] labels) {
        JLabel[] labelObjects = new JLabel[components.length];
        for (int i = 0; i < components.length; ++i) {
            labelObjects[i] = labels.length > i ? new JLabel(labels[i]) : new JLabel(" ");
        }
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        GroupLayout.ParallelGroup group = layout.createParallelGroup();
        for (JLabel label : labelObjects) {
            group = group.addComponent(label);
        }
        hGroup.addGroup(group);
        group = layout.createParallelGroup();
        for (JComponent component : components) {
            group = group.addComponent(component);
        }
        hGroup.addGroup(group);
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        for (int i = 0; i < components.length; ++i) {
            vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(labelObjects[i]).addComponent(components[i]));
        }
        layout.setVerticalGroup(vGroup);
    }

    public static void createGroup(JPanel panel, JComponent[][] components, String[][] labels) {
        JLabel[][] labelObjects = new JLabel[components.length][];
        int maxWidth = 0;
        for (int i = 0; i < components.length; ++i) {
            labelObjects[i] = new JLabel[components[i].length];
            maxWidth = Math.max(maxWidth, components[i].length);
            for (int j = 0; j < components[i].length; ++j) {
                labelObjects[i][j] = labels.length > i && labels[i].length > j ? new JLabel(labels[i][j]) : new JLabel(" ");
            }
        }
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
        for (int j = 0; j < maxWidth; ++j) {
            GroupLayout.ParallelGroup group = layout.createParallelGroup();
            for (int i = 0; i < components.length; ++i) {
                if (components[i].length > j) {
                    group.addComponent(labelObjects[i][j]);
                    continue;
                }
                group.addComponent(new JLabel(""));
            }
            hGroup.addGroup(group);
            group = layout.createParallelGroup();
            for (JComponent[] component : components) {
                if (component.length > j) {
                    group.addComponent(component[j]);
                    continue;
                }
                group.addComponent(new JLabel(""));
            }
            hGroup.addGroup(group);
        }
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        for (int i = 0; i < components.length; ++i) {
            GroupLayout.ParallelGroup group = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            for (int j = 0; j < maxWidth; ++j) {
                if (components[i].length > j) {
                    group.addComponent(labelObjects[i][j]).addComponent(components[i][j]);
                    continue;
                }
                group.addComponent(new JLabel("")).addComponent(new JLabel(""));
            }
            vGroup.addGroup(group);
        }
        layout.setVerticalGroup(vGroup);
    }
}

