/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Proxy;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.model.collections.IterableCollectionModel;
import org.ktde.swing.ObjectTableListSelectionModel;
import org.ktde.swing.ObjectTableModelAccessor;
import org.ktde.swing.ObjectTableSelectedRowInvokationHandler;
import org.ktde.swing.table.DeleteHandler;
import org.ktde.swing.table.EditHandler;
import org.ktde.swing.table.InsertHandler;

public class ObjectTable<T>
extends JPanel
implements ValueChangeListener,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1046180060717850192L;
    public static final int MODE_TABLE = 1;
    public static final int MODE_LIST = 2;
    public IterableCollectionModel<T> model;
    private JButton insertNew;
    private JButton delete;
    private JButton edit;
    private JTable table;
    private EditHandler editHandler;
    private InsertHandler insertHandler;
    private DeleteHandler deleteHandler;
    private T selectedModel;
    private Class<T> interfaceClass;

    public ObjectTable(ObjectTableModelAccessor<?> modelAccessor, Class<T> interfaceClass) {
        super(new BorderLayout());
        this.interfaceClass = interfaceClass;
        this.table = new JTable(modelAccessor);
        this.add((Component)new JScrollPane(this.table), "Center");
        Box buttonBox = new Box(0);
        this.insertNew = new JButton("einf\u00fcgen");
        buttonBox.add(this.insertNew);
        this.insertNew.addActionListener(this);
        this.insertNew.setEnabled(false);
        this.delete = new JButton("l\u00f6schen");
        buttonBox.add(this.delete);
        this.delete.addActionListener(this);
        this.delete.setEnabled(false);
        this.edit = new JButton("bearbeiten");
        buttonBox.add(this.edit);
        this.edit.addActionListener(this);
        this.edit.setEnabled(false);
        this.add((Component)buttonBox, "South");
        this.table.setSelectionModel(new ObjectTableListSelectionModel());
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    public void setModel(IterableCollectionModel<T> model) {
        if (this.model != null) {
            this.model.removeValueChangeListener(this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addValueChangeListener(this);
        }
        ((ObjectTableModelAccessor)this.table.getModel()).setElements(model);
        this.enableButtons();
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        this.enableButtons();
        if (e.getSource() != this.model) {
            ((ObjectTableListSelectionModel)this.table.getSelectionModel()).lock();
        }
        ((ObjectTableModelAccessor)this.table.getModel()).fireTableDataChanged();
        if (e.getSource() != this.model) {
            ((ObjectTableListSelectionModel)this.table.getSelectionModel()).release();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.insertNew) {
            int index = this.table.getSelectedRow();
            this.insertHandler.handleInsert(this.model, index);
        } else if (e.getSource() == this.edit) {
            int index = this.table.getSelectedRow();
            this.editHandler.handleEdit(this.model, index);
        } else if (e.getSource() == this.delete) {
            int[] indexes = this.table.getSelectedRows();
            this.deleteHandler.handleDelete(this.model, indexes);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableButtons();
    }

    private void enableButtons() {
        this.insertNew.setEnabled(this.insertHandler != null && this.model.canAppend());
        int[] o = this.table.getSelectedRows();
        boolean b = false;
        if (this.deleteHandler != null && o.length > 0) {
            b = true;
            for (int i = 0; i < o.length; ++i) {
                if (this.model.canDelete(o[i])) continue;
                b = false;
                break;
            }
        }
        this.delete.setEnabled(b);
        this.edit.setEnabled(this.editHandler != null && o.length == 1 && this.model.canEdit(o[0]));
    }

    public void setInsertHandler(InsertHandler handler) {
        this.insertHandler = handler;
    }

    public void setEditHandler(EditHandler handler) {
        this.editHandler = handler;
    }

    public void setDeleteHandler(DeleteHandler handler) {
        this.deleteHandler = handler;
    }

    public T getSelectedModel() {
        if (this.selectedModel == null) {
            ClassLoader loader = this.interfaceClass.getClassLoader();
            ObjectTableSelectedRowInvokationHandler<T> handler = new ObjectTableSelectedRowInvokationHandler<T>(this, this.interfaceClass);
            this.table.getSelectionModel().addListSelectionListener(handler);
            Object proxyInst = Proxy.newProxyInstance(loader, new Class[]{this.interfaceClass}, handler);
            this.selectedModel = proxyInst;
        }
        return this.selectedModel;
    }

    public T getCurrentlySelectedModel() {
        int index = this.table.getSelectionModel().getMinSelectionIndex();
        if (index != -1) {
            return this.getModelAt(index);
        }
        return null;
    }

    public T getModelAt(int i) {
        return this.model.get(i);
    }
}

