/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

public class MouseFader
extends JPanel
implements MouseListener,
MouseMotionListener,
Runnable {
    private static final long serialVersionUID = -3369487980057645914L;
    private static final Stroke DRAWSTROKE = new BasicStroke(4.5f, 1, 1);
    private static final Stroke DRAWSTROKE2 = new BasicStroke(4.0f, 1, 1);
    private static final Stroke DRAWSTROKE3 = new BasicStroke(2.5f, 1, 1);
    private Color hilightColor = new Color(255, 255, 255, 127);
    private Color leftColor;
    private Point mousePoint;
    private int button;
    private List<Point> pointsLeft = new LinkedList<Point>();

    public MouseFader() {
        this.setBackground(Color.BLACK);
        this.leftColor = Color.CYAN;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        new Thread(this).start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setPoint(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setPoint(e);
        switch (e.getButton()) {
            case 1: {
                this.button |= 0x400;
                break;
            }
            case 2: {
                this.button |= 0x800;
                break;
            }
            case 3: {
                this.button |= 0x1000;
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setPoint(e);
        switch (e.getButton()) {
            case 1: {
                this.button &= 0xFFFFFBFF;
                break;
            }
            case 2: {
                this.button &= 0xFFFFF7FF;
                break;
            }
            case 3: {
                this.button &= 0xFFFFEFFF;
                break;
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setPoint(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setPoint(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setPoint(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setPoint(e);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath();
        if (!this.pointsLeft.isEmpty()) {
            Iterator<Point> iter = this.pointsLeft.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                Point p = iter.next();
                if (p == null) {
                    first = true;
                    continue;
                }
                if (first) {
                    first = false;
                    path.moveTo(p.x, p.y);
                    continue;
                }
                path.lineTo(p.x, p.y);
            }
            g2d.setColor(this.hilightColor);
            g2d.setStroke(DRAWSTROKE);
            g2d.draw(path);
            g2d.setColor(this.leftColor);
            g2d.setStroke(DRAWSTROKE2);
            g2d.draw(path);
            g2d.setColor(this.hilightColor);
            g2d.setStroke(DRAWSTROKE3);
            g2d.draw(path);
            float[] dashpattern = this.createDash(System.currentTimeMillis());
            BasicStroke DRAWSTROKE4 = new BasicStroke(1.5f, 1, 1, 0.0f, dashpattern, 0.0f);
            g2d.setStroke(DRAWSTROKE4);
            g2d.draw(path);
            g2d.draw(path);
        }
    }

    private float[] createDash(long s) {
        float[] dashpattern = new float[10];
        float deflen = 70.0f;
        for (int i = 0; i < dashpattern.length; ++i) {
            double x = (double)(s + (long)i) / 1000.0;
            dashpattern[i] = (float)((double)deflen * 1.5 - (Math.sin(x * 30.0) + Math.cos(x * 600.0) + Math.sin(x) + Math.cos(x / 100.0) - Math.sin(x * 3.0) * Math.cos(x * 4.0)));
        }
        return dashpattern;
    }

    private void setPoint(Point mousePoint) {
        this.mousePoint = mousePoint;
        if ((this.button & 0x400) == 1024) {
            this.pointsLeft.add(mousePoint);
        } else {
            this.pointsLeft.add(null);
        }
        while (this.pointsLeft.size() > 60) {
            this.pointsLeft.remove(0);
        }
    }

    private void setPoint(MouseEvent e) {
        this.setPoint(new Point(e.getX(), e.getY()));
    }

    @Override
    public void run() {
        while (true) {
            this.setPoint(this.mousePoint);
            this.repaint(10L);
            try {
                Thread.sleep(45L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

