/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.ktde.model.Model;
import org.ktde.model.collections.AbstractUnsortedCollectionModel;
import org.ktde.util.cache.TwoLevelCache;
import org.ktde.util.function.DefaultConstantFunction;
import org.ktde.util.function.Function;

public class SetModel<T extends Model>
extends AbstractUnsortedCollectionModel<T>
implements Set<T> {
    private Set<T> elements = new HashSet<T>();
    private Function<Boolean> canSet;
    private Function<Boolean> canEdit;

    @Override
    public Collection<T> getAsCollection() {
        return this.elements;
    }

    @Override
    protected void set(T oldValue, T newValue) {
        if (this.elements.contains(oldValue)) {
            this.elements.remove(oldValue);
            this.elements.add(newValue);
            this.fireValueChanged(this, null);
        }
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void performAppend(T value) {
        this.elements.add(value);
    }

    public Function<Boolean> getCanSet() {
        return this.canSet;
    }

    public void setCanSet(Function<Boolean> canSet) {
        this.canSet = canSet;
    }

    public Function<Boolean> getCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(Function<Boolean> canEdit) {
        this.canEdit = canEdit;
    }

    @Override
    public boolean canSet(T newValue, T oldValue) {
        HashMap variables = new HashMap();
        variables.put("object", new DefaultConstantFunction<T>(oldValue));
        variables.put("newobject", new DefaultConstantFunction<T>(newValue));
        return this.canSet.evaluate(variables);
    }

    @Override
    public boolean canEdit(T value) {
        HashMap variables = new HashMap();
        variables.put("object", new DefaultConstantFunction<T>(value));
        return this.canEdit.evaluate(variables);
    }

    @Override
    public String toString() {
        return this.elements.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    protected void performDelete(T element) {
        this.elements.remove(element);
    }

    @Override
    public SetModel<T> getEditableClone(TwoLevelCache<Class<? extends Model>, Long, Model> cache) {
        SetModel<Model> editableClone = new SetModel<Model>();
        editableClone.setCanAppendAnonymous(this.getCanAppendAnonymous());
        editableClone.setCanAppendObject(this.getCanAppendObject());
        editableClone.setCanDelete(this.getCanDelete());
        editableClone.setCanSet(this.getCanSet());
        editableClone.setCanEdit(this.getCanEdit());
        for (Model model : this.elements) {
            editableClone.add(model.getEditableClone(cache));
        }
        return editableClone;
    }
}

