/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.ktde.model.AbstractModel;
import org.ktde.model.BooleanModel;
import org.ktde.model.IntegerModel;
import org.ktde.model.Model;
import org.ktde.model.ScalarModel;
import org.ktde.model.collections.CollectionModel;
import org.ktde.util.cache.TwoLevelCache;
import org.ktde.util.function.DefaultConstantFunction;
import org.ktde.util.function.Function;

public abstract class AbstractCollectionModel<T>
extends AbstractModel
implements Collection<T>,
CollectionModel<T> {
    private SizeModel sizeModel;
    private EmptyModel emptyModel;
    private Function<Boolean> canAppendAnonymous;
    private Function<Boolean> canAppendObject;
    private Function<Boolean> canDelete;

    protected void changeSize() {
        if (this.sizeModel != null) {
            this.sizeModel.changeSize();
        }
        if (this.emptyModel != null) {
            this.emptyModel.changeSize();
        }
    }

    @Override
    public ScalarModel<Integer> getSizeModel() {
        if (this.sizeModel == null) {
            this.sizeModel = new SizeModel();
        }
        return this.sizeModel;
    }

    @Override
    public ScalarModel<Boolean> getEmptyModel() {
        if (this.emptyModel == null) {
            this.emptyModel = new EmptyModel();
        }
        return this.emptyModel;
    }

    @Override
    public boolean canAppend(T value) {
        HashMap variables = new HashMap();
        variables.put("newobject", new DefaultConstantFunction<T>(value));
        return this.canAppendObject.evaluate(variables);
    }

    @Override
    public boolean canAppend() {
        HashMap variables = new HashMap();
        return this.canAppendAnonymous.evaluate(variables);
    }

    @Override
    public final boolean canDelete(T value) {
        HashMap variables = new HashMap();
        variables.put("object", new DefaultConstantFunction<T>(value));
        return this.canDelete.evaluate(variables);
    }

    public void setCanAppendAnonymous(Function<Boolean> canAppendAnonymous) {
        this.canAppendAnonymous = canAppendAnonymous;
    }

    public Function<Boolean> getCanAppendAnonymous() {
        return this.canAppendAnonymous;
    }

    public void setCanAppendObject(Function<Boolean> canAppendObject) {
        this.canAppendObject = canAppendObject;
    }

    public Function<Boolean> getCanAppendObject() {
        return this.canAppendObject;
    }

    public void setCanDelete(Function<Boolean> canDelete) {
        this.canDelete = canDelete;
    }

    public Function<Boolean> getCanDelete() {
        return this.canDelete;
    }

    protected abstract void performAppend(T var1);

    @Override
    public final void append(T value) {
        this.performAppend(value);
        this.fireValueChanged(this, null);
        this.changeSize();
    }

    protected abstract void performDelete(T var1);

    @Override
    public final void delete(T value) {
        this.performDelete(value);
        this.fireValueChanged(this, null);
        this.changeSize();
    }

    @Override
    public abstract Iterator<T> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(T e) {
        if (this.canAppend(e)) {
            this.append(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = true;
        for (T name : c) {
            result = result && this.add(name);
        }
        return result;
    }

    public boolean canClear() {
        for (T t : this) {
            if (this.canDelete(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        Object[] check;
        for (Object element : check = this.toArray()) {
            this.remove(element);
        }
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this) {
            if (!(t == null ? o == null : t.equals(o))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        for (Object name : c) {
            result = result && this.contains(name);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        try {
            Object t = o;
            if (this.canDelete(t)) {
                this.delete(t);
                result = true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = true;
        for (Object name : c) {
            result = result && this.remove(name);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] check;
        boolean result = true;
        for (Object element : check = this.toArray()) {
            Object o = element;
            if (c.contains(o)) continue;
            result = result && this.remove(o);
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            a[i++] = iterator.next();
        }
        return a;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        int i = 0;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T t;
            T s = t = iterator.next();
            a[i++] = s;
        }
        return a;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String link = "";
        sb.append("[");
        for (T t : this) {
            sb.append(link);
            link = ", ";
            sb.append(t.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private class EmptyModel
    extends AbstractModel
    implements BooleanModel {
        boolean empty;

        EmptyModel() {
            this.empty = AbstractCollectionModel.this.isEmpty();
        }

        void changeSize() {
            boolean oldValue = this.empty;
            this.empty = AbstractCollectionModel.this.isEmpty();
            this.fireValueChanged(this.empty, oldValue);
        }

        @Override
        public Boolean getValue() {
            return this.empty;
        }

        @Override
        public ScalarModel<Boolean> createInstance() {
            return null;
        }

        @Override
        public ScalarModel<Boolean> createInstance(Boolean value) {
            return null;
        }

        @Override
        public void setValue(Boolean value) {
        }

        @Override
        public Boolean parseValueFromString(String string) {
            return null;
        }

        public BooleanModel clone() {
            return this;
        }

        @Override
        public Model getEditableClone(TwoLevelCache<Class<? extends Model>, Long, Model> cache) {
            return this;
        }
    }

    private class SizeModel
    extends AbstractModel
    implements IntegerModel {
        int size;

        SizeModel() {
            this.size = AbstractCollectionModel.this.size();
        }

        void changeSize() {
            int oldValue = this.size;
            this.size = AbstractCollectionModel.this.size();
            this.fireValueChanged(this.size, oldValue);
        }

        @Override
        public Integer getValue() {
            return this.size;
        }

        @Override
        public ScalarModel<Integer> createInstance() {
            return null;
        }

        @Override
        public ScalarModel<Integer> createInstance(Integer value) {
            return null;
        }

        @Override
        public void setValue(Integer value) {
        }

        @Override
        public Integer parseValueFromString(String string) {
            return null;
        }

        public IntegerModel clone() {
            return this;
        }

        @Override
        public Model getEditableClone(TwoLevelCache<Class<? extends Model>, Long, Model> cache) {
            return this;
        }
    }
}

