/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model;

import java.awt.event.ActionEvent;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.ktde.model.Model;
import org.ktde.model.SaveModelsAction;

public abstract class AbstractSaveModelsAction
extends AbstractAction
implements SaveModelsAction {
    private static final long serialVersionUID = 6541470768655668437L;
    protected Map<Model, Integer> enqueuedModels = new IdentityHashMap<Model, Integer>();

    public AbstractSaveModelsAction() {
    }

    public AbstractSaveModelsAction(String name) {
        super(name);
    }

    public AbstractSaveModelsAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void enqueueModel(Model model) {
        Integer i = this.enqueuedModels.get(model);
        if (i == null) {
            this.enqueuedModels.put(model, 1);
        } else {
            this.enqueuedModels.put(model, i + 1);
        }
    }

    @Override
    public void removeModel(Model model) {
        Integer i = this.enqueuedModels.get(model);
        if (i != null) {
            if (i == 1) {
                this.enqueuedModels.remove(model);
            } else {
                this.enqueuedModels.put(model, i - 1);
            }
        }
    }

    @Override
    public void clear() {
        this.enqueuedModels.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.performSave()) {
            this.clear();
        }
    }

    public abstract boolean performSave();
}

