/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model;

import javax.swing.event.EventListenerList;
import org.ktde.model.Model;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public abstract class AbstractModel
implements Model {
    private boolean dirty = false;
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.listenerList.add(ValueChangeListener.class, listener);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listenerList.remove(ValueChangeListener.class, listener);
    }

    protected void fireValueChanged(Object newValue, Object oldValue) {
        this.fireValueChangeEvent(new ValueChangeEvent(this, ValueChangeEvent.Type.UPDATE, newValue, oldValue, null));
    }

    protected void fireValueChangeEvent(ValueChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ValueChangeListener)listeners[i + 1]).valueChanged(e);
        }
    }
}

