/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model;

import javax.swing.event.EventListenerList;
import org.ktde.model.BooleanDelegatingModel;
import org.ktde.model.BooleanModel;
import org.ktde.model.DateDelegatingModel;
import org.ktde.model.DateModel;
import org.ktde.model.IntegerDelegatingModel;
import org.ktde.model.IntegerModel;
import org.ktde.model.LongDelegatingModel;
import org.ktde.model.LongModel;
import org.ktde.model.Model;
import org.ktde.model.StringDelegatingModel;
import org.ktde.model.StringModel;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public abstract class AbstractDelegatingModel<T extends Model>
implements Model,
ValueChangeListener {
    private T delegate;
    private EventListenerList listenerList;

    public AbstractDelegatingModel() {
        this(null);
    }

    public AbstractDelegatingModel(T delegate) {
        this.delegate = delegate;
        this.listenerList = new EventListenerList();
    }

    public T getDelegate() {
        return this.delegate;
    }

    public void setDelegate(T delegate) {
        if (this.delegate != delegate) {
            T oldDelegate = this.delegate;
            if (this.delegate != null && this.listenerList.getListenerCount() > 0) {
                this.delegate.removeValueChangeListener(this);
            }
            this.delegate = delegate;
            if (delegate != null && this.listenerList.getListenerCount() > 0) {
                this.delegate.addValueChangeListener(this);
            }
            this.fireDelegateChanged((Model)this.delegate, (Model)oldDelegate);
        }
    }

    @Override
    public boolean isDirty() {
        if (this.delegate != null) {
            return this.delegate.isDirty();
        }
        return false;
    }

    @Override
    public void setDirty(boolean flag) {
        if (this.delegate != null) {
            this.delegate.setDirty(flag);
        }
    }

    @Override
    public synchronized void addValueChangeListener(ValueChangeListener listener) {
        if (this.delegate != null && this.listenerList.getListenerCount() == 0) {
            this.delegate.addValueChangeListener(this);
        }
        this.listenerList.add(ValueChangeListener.class, listener);
    }

    @Override
    public synchronized void removeValueChangeListener(ValueChangeListener listener) {
        this.listenerList.remove(ValueChangeListener.class, listener);
        if (this.delegate != null && this.listenerList.getListenerCount() == 0) {
            this.delegate.removeValueChangeListener(this);
        }
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        this.fireValueChanged(e.getNewValue(), e.getOldValue());
    }

    protected void fireDelegateChanged(Model delegate, Model oldDelegate) {
    }

    protected void fireValueChanged(Object newValue, Object oldValue) {
        this.fireValueChangeEvent(new ValueChangeEvent(this, ValueChangeEvent.Type.UPDATE, newValue, oldValue, null));
    }

    protected void fireValueChangeEvent(ValueChangeEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ValueChangeListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public static AbstractDelegatingModel<? extends Model> createDelegateModel(Class<?> delegateClazz) {
        if (StringModel.class.isAssignableFrom(delegateClazz)) {
            return new StringDelegatingModel();
        }
        if (IntegerModel.class.isAssignableFrom(delegateClazz)) {
            return new IntegerDelegatingModel();
        }
        if (LongModel.class.isAssignableFrom(delegateClazz)) {
            return new LongDelegatingModel();
        }
        if (BooleanModel.class.isAssignableFrom(delegateClazz)) {
            return new BooleanDelegatingModel();
        }
        if (DateModel.class.isAssignableFrom(delegateClazz)) {
            return new DateDelegatingModel();
        }
        return null;
    }

    public static AbstractDelegatingModel<? extends Model> createDelegateModel(Model delegate) {
        AbstractDelegatingModel<Model> model = AbstractDelegatingModel.createDelegateModel(delegate.getClass());
        model.setDelegate(delegate);
        return model;
    }
}

