/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection.generic;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.generic.AbstractGenericCoordinateFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class UtmFactory
extends AbstractGenericCoordinateFactory {
    public static final UtmFactory INSTANCE;
    private static final long serialVersionUID = 5176680108488303507L;

    public UtmFactory() throws NoSuchAuthorityCodeException, FactoryException {
        super(25832);
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.Utm;
    }

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        double d = coordinate.getX();
        double zone = Math.floor(d / 1000000.0);
        Coordinate dCoord = coordinate.getFactory().createCoordinate(d -= (zone *= 1000000.0), coordinate.getY());
        return super.transformToGeoDecimal(dCoord);
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        double y = coordinate.getX();
        if (y > 180.0) {
            y -= 360.0;
        }
        double zone = (long)((y + 180.0) / 6.0) % 60L + 1L;
        Coordinate c = super.transformFromGeoDecimal(coordinate);
        double x = c.getX();
        return c.getFactory().createCoordinate(x += (zone *= 1000000.0), c.getY());
    }

    @Override
    public boolean isListable() {
        return false;
    }

    static {
        try {
            INSTANCE = new UtmFactory();
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}

