/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection.generic;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.epsg.ThreadedHsqlEpsgFactory;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGenericCoordinateFactory
extends CoordinateFactory {
    private static final long serialVersionUID = -7919887851729059804L;
    private int epsg;
    private CoordinateReferenceSystem source;
    private CoordinateReferenceSystem geoDecimal;
    private MathTransform toGeoDecimal;
    private MathTransform fromGeoDecimal;

    public AbstractGenericCoordinateFactory(int epsg) throws NoSuchAuthorityCodeException, FactoryException {
        this.epsg = epsg;
        this.source = CRS.decode("EPSG:" + this.epsg);
        this.geoDecimal = CRS.decode("EPSG:4326");
        this.toGeoDecimal = CRS.findMathTransform(this.source, this.geoDecimal, true);
        this.fromGeoDecimal = CRS.findMathTransform(this.geoDecimal, this.source, true);
    }

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        try {
            Point geo = new GeometryFactory().createPoint(new com.vividsolutions.jts.geom.Coordinate(coordinate.getX(), coordinate.getY()));
            Geometry out = JTS.transform(geo, this.toGeoDecimal);
            double y = out.getCoordinate().y * 100000.0;
            double x = out.getCoordinate().x * 100000.0;
            return GeoDecimalFactory.INSTANCE.createCoordinate(y, x);
        }
        catch (MismatchedDimensionException e) {
            throw new RuntimeException(e);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        try {
            Point geo = new GeometryFactory().createPoint(new com.vividsolutions.jts.geom.Coordinate(coordinate.getY() / 100000.0, coordinate.getX() / 100000.0));
            Geometry out = JTS.transform(geo, this.fromGeoDecimal);
            double y = out.getCoordinate().y;
            double x = out.getCoordinate().x;
            return this.createCoordinate(x, y);
        }
        catch (MismatchedDimensionException e) {
            throw new RuntimeException(e);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getEpsg() {
        return this.epsg;
    }

    @Override
    public double getRefScale() {
        return 1.0;
    }

    static {
        try {
            ReferencingFactoryFinder.addAuthorityFactory(new ThreadedHsqlEpsgFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

