/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;

public class OpenStreetmapViewFactory
extends CoordinateFactory {
    private static final long serialVersionUID = 1057512082690184849L;
    private double translationX = 1.7861793E7;
    private double translationY = 5126594.0;
    private int refzoom = 17;
    private int maxtile = 1 << this.refzoom;
    private int tilesizeX;
    private int tilesizeY = this.tilesizeX = 256;
    public static final OpenStreetmapViewFactory INSTANCE = new OpenStreetmapViewFactory();

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        double lon = coordinate.getX() / 100000.0;
        double lat = coordinate.getY() / 100000.0;
        double xtile = (lon + 180.0) / 360.0 * (double)this.maxtile;
        double ytile = (1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)this.maxtile;
        ytile = (double)this.maxtile / 2.0 - ytile;
        double z = coordinate.getZ();
        return new Coordinate(this, xtile * (double)this.tilesizeX - this.translationX, ytile * (double)this.tilesizeY - this.translationY, z);
    }

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double z = coordinate.getZ();
        double xtile = (x + this.translationX) / (double)this.tilesizeX;
        double ytile = (y + this.translationY) / (double)this.tilesizeY;
        ytile = (double)this.maxtile / 2.0 - ytile;
        double lon = xtile / (double)this.maxtile * 360.0 - 180.0;
        double latRad = Math.atan(Math.sinh(Math.PI * (1.0 - 2.0 * ytile / (double)this.maxtile)));
        double lat = Math.toDegrees(latRad);
        return new Coordinate(GeoDecimalFactory.INSTANCE, lon * 100000.0, lat * 100000.0, z);
    }

    public String toString() {
        return "OSM-View";
    }

    @Override
    public int getEpsg() {
        return -1;
    }

    @Override
    public double getRefScale() {
        return 1.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.OpenStreetmapView;
    }

    @Override
    public boolean isListable() {
        return false;
    }
}

