/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;

public class MercatorFactory
extends CoordinateFactory {
    private static final long serialVersionUID = -6636746897825862910L;
    public static final MercatorFactory INSTANCE = new MercatorFactory();
    public static final String CLASS_NAME = "org.ktde.math.projection.MercatorFactory";

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        double x = this.getSphericalRadius() * coordinate.getX() * Math.PI / 1.8E7;
        double y = this.getSphericalRadius() * Math.log(Math.tan(Math.PI * (9000000.0 + coordinate.getY()) / 3.6E7));
        double z = coordinate.getZ();
        return new Coordinate(this, x, y, z);
    }

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        double x = 100000.0 * (coordinate.getX() * 180.0 / Math.PI) / this.getSphericalRadius();
        double y = Math.atan(Math.exp(coordinate.getY() / this.getSphericalRadius())) * 3.6E7 / Math.PI - 9000000.0;
        double z = coordinate.getZ();
        return new Coordinate(GeoDecimalFactory.INSTANCE, x, y, z);
    }

    public String toString() {
        return "Mercator";
    }

    @Override
    public int getEpsg() {
        return 505456;
    }

    @Override
    public String getStringX(Coordinate c) {
        return "" + (int)c.getX();
    }

    @Override
    public String getStringY(Coordinate c) {
        return "" + (int)c.getY();
    }

    @Override
    public double getRefScale() {
        return 1.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.Mercator;
    }

    @Override
    public boolean isListable() {
        return true;
    }
}

