/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;

public class GeoDecimalFactory
extends CoordinateFactory {
    private static final long serialVersionUID = 886702556039859591L;
    public static final double GEODECIMAL_STD_FACTOR = 100000.0;
    public static final GeoDecimalFactory INSTANCE = new GeoDecimalFactory();
    private double factor;

    public GeoDecimalFactory() {
        this(100000.0);
    }

    public GeoDecimalFactory(double factor) {
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        if (this.factor == 100000.0) {
            return coordinate;
        }
        double correct = this.factor / 100000.0;
        double x = coordinate.getX() * correct;
        double y = coordinate.getY() * correct;
        double z = coordinate.getZ() * correct;
        return new Coordinate(this, x, y, z);
    }

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        if (this.factor == 100000.0) {
            return coordinate;
        }
        double correct = 100000.0 / this.factor;
        double x = coordinate.getX() * correct;
        double y = coordinate.getY() * correct;
        double z = coordinate.getZ() * correct;
        return new Coordinate(INSTANCE, x, y, z);
    }

    public String toString() {
        return "GeoDecimal-" + this.factor;
    }

    @Override
    public int getEpsg() {
        return 4326;
    }

    @Override
    public double getRefScale() {
        return this.factor / 100000.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.GeoDecimal;
    }

    @Override
    public boolean isListable() {
        return false;
    }
}

