/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;

public class DegreeMinuteCoordinateFactory
extends CoordinateFactory {
    private static final long serialVersionUID = -4249581272952936818L;
    public static final CoordinateFactory INSTANCE = new DegreeMinuteCoordinateFactory();

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        double x = this.degreeMinuteToDez(coordinate.getX());
        double y = this.degreeMinuteToDez(coordinate.getY());
        double z = this.degreeMinuteToDez(coordinate.getZ());
        return new Coordinate(GeoDecimalFactory.INSTANCE, x * 100000.0, y * 100000.0, z);
    }

    private double degreeMinuteToDez(double d) {
        double g = Math.floor(d);
        double dez = (d - g) * 100.0;
        return g + dez / 60.0;
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        double x = this.dezToDegreeMinute(coordinate.getX() / 100000.0);
        double y = this.dezToDegreeMinute(coordinate.getY() / 100000.0);
        double z = this.dezToDegreeMinute(coordinate.getZ());
        return new Coordinate(this, x, y, z);
    }

    private double dezToDegreeMinute(double d) {
        double g = Math.floor(d);
        double m = (d - g) * 60.0;
        return g + m / 100.0;
    }

    @Override
    public int getEpsg() {
        return -1;
    }

    @Override
    public double getRefScale() {
        return 1.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.DegreeMinute;
    }

    @Override
    public boolean isListable() {
        return true;
    }
}

