/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.DegreeMinuteCoordinateFactory;
import org.ktde.math.projection.GaussKruegerFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.GeoDecimal10Factory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.ktde.math.projection.KatasterCoordinateFactory;
import org.ktde.math.projection.Lv95CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.math.projection.PotsdamCoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.math.projection.generic.Etrs89Utm32NFactory;
import org.ktde.math.projection.generic.Etrs89Utm33NFactory;
import org.ktde.math.projection.generic.UtmFactory;

public abstract class CoordinateFactory
implements Serializable {
    private static final long serialVersionUID = -4886315944903802369L;
    public static final double EARTH_RADIUS = 6371000.0;
    private double sphericalRadius;

    public CoordinateFactory() {
        this(6371000.0);
    }

    public CoordinateFactory(double sphericalRadius) {
        this.sphericalRadius = sphericalRadius;
    }

    public Coordinate createCoordinate(double x, double y) {
        return this.createCoordinate(x, y, 0.0);
    }

    public Coordinate createCoordinate(double x, double y, double z) {
        return new Coordinate(this, x, y, z);
    }

    public Coordinate createCoordinate(Point2D point) {
        return this.createCoordinate(point.getX(), point.getY(), 0.0);
    }

    public Coordinate createCoordinate(Coordinate coordinate) {
        CoordinateFactory oldFactory = coordinate.getFactory();
        Coordinate geoCoordinate = oldFactory.transformToGeoDecimal(coordinate);
        return this.transformFromGeoDecimal(geoCoordinate);
    }

    public void transformCoordinate(com.vividsolutions.jts.geom.Coordinate coordinate, CoordinateFactory oldFactory) {
        Coordinate oldCoordinate = oldFactory.createCoordinate(coordinate.x, coordinate.y, coordinate.z);
        Coordinate geoCoordinate = this.createCoordinate(oldCoordinate);
        coordinate.x = geoCoordinate.getX();
        coordinate.y = geoCoordinate.getY();
        coordinate.z = geoCoordinate.getZ();
    }

    protected abstract Coordinate transformToGeoDecimal(Coordinate var1);

    protected abstract Coordinate transformFromGeoDecimal(Coordinate var1);

    public double getSphericalRadius() {
        return this.sphericalRadius;
    }

    public abstract int getEpsg();

    public static Collection<Projections> getListableProjections() {
        LinkedList<Projections> projectionList = new LinkedList<Projections>();
        for (Projections projection : Projections.values()) {
            CoordinateFactory coordinateFactory = CoordinateFactory.getInstance(projection);
            if (!coordinateFactory.isListable()) continue;
            projectionList.add(projection);
        }
        return projectionList;
    }

    public static CoordinateFactory getInstance(Projections coordType) {
        switch (coordType) {
            case Wgs84: {
                return Wgs84Factory.INSTANCE;
            }
            case Mercator: {
                return MercatorFactory.INSTANCE;
            }
            case GeoDecimal: {
                return GeoDecimalFactory.INSTANCE;
            }
            case GeoDecimal10: {
                return GeoDecimal10Factory.INSTANCE;
            }
            case GeoDecimal100: {
                return GeoDecimal100Factory.INSTANCE;
            }
            case GaussKrueger: {
                return GaussKruegerFactory.INSTANCE;
            }
            case OpenStreetmapView: {
                return OpenStreetmapViewFactory.INSTANCE;
            }
            case Utm: {
                return UtmFactory.INSTANCE;
            }
            case DegreeMinute: {
                return DegreeMinuteCoordinateFactory.INSTANCE;
            }
            case Potsdam: {
                return PotsdamCoordinateFactory.INSTANCE;
            }
            case Etrs89Utm33N: {
                return Etrs89Utm33NFactory.INSTANCE;
            }
            case Etrs89Utm32N: {
                return Etrs89Utm32NFactory.INSTANCE;
            }
            case Kataster: {
                return KatasterCoordinateFactory.INSTANCE;
            }
            case Lv95: {
                return Lv95CoordinateFactory.INSTANCE;
            }
        }
        return null;
    }

    public static CoordinateFactory getInstance(String coordinateFactoryName) {
        try {
            return CoordinateFactory.getInstance(Projections.valueOf(coordinateFactoryName));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected DecimalFormat getDecimalFormat() {
        return new DecimalFormat("###.######", DecimalFormatSymbols.getInstance(Locale.US));
    }

    public String getStringX(Coordinate c) {
        DecimalFormat format = this.getDecimalFormat();
        return format.format(c.getX());
    }

    public String getStringY(Coordinate c) {
        DecimalFormat format = this.getDecimalFormat();
        return format.format(c.getY());
    }

    public abstract double getRefScale();

    public String getName() {
        String simplename = this.getClass().getSimpleName();
        return simplename.substring(0, simplename.length() - 7);
    }

    public static String formatCoordinate(Coordinate coordinate, String east, String west, String north, String south) {
        coordinate = Wgs84Factory.INSTANCE.createCoordinate(coordinate);
        return CoordinateFactory.formatPart(coordinate.getX(), east, west) + ", " + CoordinateFactory.formatPart(coordinate.getY(), north, south);
    }

    private static String formatPart(double d, String pos, String neg) {
        boolean n = d < 0.0;
        d = Math.abs(d);
        int i = (int)Math.floor(d);
        double min = (d - (double)i) * 60.0;
        int m = (int)Math.floor(min);
        double sec = (min - (double)m) * 60.0;
        int s = (int)Math.floor(sec);
        double msec = (sec - (double)s) * 10.0;
        int ms = (int)Math.round(msec);
        return i + "\u00b0" + m + "'" + s + "." + ms + "\" " + (n ? neg : pos);
    }

    public abstract Projections getProjection();

    public boolean equals(Object obj) {
        if (obj instanceof CoordinateFactory) {
            CoordinateFactory other = (CoordinateFactory)obj;
            return this.getProjection() == other.getProjection();
        }
        return false;
    }

    public int hashCode() {
        return this.getProjection().hashCode();
    }

    public abstract boolean isListable();

    public static enum Projections {
        Wgs84,
        Mercator,
        GeoDecimal,
        GeoDecimal10,
        GeoDecimal100,
        GaussKrueger,
        OpenStreetmapView,
        Utm,
        DegreeMinute,
        Potsdam,
        Etrs89Utm33N,
        Etrs89Utm32N,
        Kataster,
        Lv95;

    }
}

