/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractPotsdamBasedCoordinateFactory
extends CoordinateFactory {
    private static final long serialVersionUID = 8383032829048506498L;

    public static Tupel<Double, Double> potToWgs84(double ox, double oy) {
        double a = 6377397.155;
        double fq = 0.00334277318;
        double f = 0.00335281066;
        double dx = 587.0;
        double dy = 16.0;
        double dz = 393.0;
        double e2q = 2.0 * fq - fq * fq;
        double e2 = 2.0 * f - f * f;
        double pi = Math.PI;
        double b1 = oy * (pi / 180.0);
        double l1 = ox * (pi / 180.0);
        double nd = a / Math.sqrt(1.0 - e2q * Math.sin(b1) * Math.sin(b1));
        double xp = nd * Math.cos(b1) * Math.cos(l1);
        double yp = nd * Math.cos(b1) * Math.sin(l1);
        double zp = (1.0 - e2q) * nd * Math.sin(b1);
        double x = xp + dx;
        double y = yp + dy;
        double z = zp + dz;
        double rb = Math.sqrt(x * x + y * y);
        double l2 = 0.0;
        double b2 = 180.0 / pi * Math.atan(z / rb / (1.0 - e2));
        if (x > 0.0) {
            l2 = 180.0 / pi * Math.atan(y / x);
        } else if (y > 0.0) {
            l2 = 180.0 / pi * Math.atan(y / x) + 180.0;
        } else if (y < 0.0) {
            l2 = 180.0 / pi * Math.atan(y / x) - 180.0;
        }
        double lw = l2;
        double bw = b2;
        lw = (double)Math.round(lw * 1.0E7) / 1.0E7;
        bw = (double)Math.round(bw * 1.0E7) / 1.0E7;
        return new Tupel<Double, Double>(lw, bw);
    }

    protected Tupel<Double, Double> wgs84ToPot(double ox, double oy) {
        double a = 6378137.0;
        double fq = 0.00335281066;
        double f = fq - 1.003748E-5;
        double dx = -587.0;
        double dy = -16.0;
        double dz = -393.0;
        double e2q = 2.0 * fq - fq * fq;
        double e2 = 2.0 * f - f * f;
        double pi = Math.PI;
        double b1 = oy * (pi / 180.0);
        double l1 = ox * (pi / 180.0);
        double nd = a / Math.sqrt(1.0 - e2q * Math.sin(b1) * Math.sin(b1));
        double xw = nd * Math.cos(b1) * Math.cos(l1);
        double yw = nd * Math.cos(b1) * Math.sin(l1);
        double zw = (1.0 - e2q) * nd * Math.sin(b1);
        double x = xw + dx;
        double y = yw + dy;
        double z = zw + dz;
        double rb = Math.sqrt(x * x + y * y);
        double b2 = 180.0 / pi * Math.atan(z / rb / (1.0 - e2));
        double l2 = 0.0;
        if (x > 0.0) {
            l2 = 180.0 / pi * Math.atan(y / x);
        } else if (y > 0.0) {
            l2 = 180.0 / pi * Math.atan(y / x) + 180.0;
        } else if (y < 0.0) {
            l2 = 180.0 / pi * Math.atan(y / x) - 180.0;
        }
        double lp = l2;
        double bp = b2;
        return new Tupel<Double, Double>(lp, bp);
    }
}

