/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.util.Collections;
import java.util.Vector;
import org.ktde.math.helper.PartedNumberPartComparator;
import org.ktde.math.number.ComplexNumber;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedFraction;
import org.ktde.math.number.PartedNumberSum;
import org.ktde.math.number.RootNumber;
import org.ktde.math.number.SymbolNumber;
import org.ktde.util.datatypes.Tupel;

public class PartedNumber
extends PartedNumberSum {
    protected IntegerFraction factor;
    protected Vector<Tupel<SymbolNumber, IntegerNumber>> parts;

    protected PartedNumber(String tostring) {
        super(tostring);
    }

    private PartedNumber(IntegerFraction factor, Vector<Tupel<SymbolNumber, IntegerNumber>> parts) {
        this(PartedNumber.calcToString(factor, parts));
        this.factor = factor;
        this.parts = parts;
    }

    private static String calcToString(IntegerFraction factor, Vector<Tupel<SymbolNumber, IntegerNumber>> parts) {
        StringBuffer res = new StringBuffer();
        if (!factor.equals(IntegerNumber.ONE)) {
            res.append(factor.toString());
        }
        for (Tupel<SymbolNumber, IntegerNumber> part : parts) {
            res.append(part.getElement1().toString());
            IntegerNumber ex = part.getElement2();
            if (ex.equals(IntegerNumber.ONE)) continue;
            res.append("^");
            res.append(ex.toString());
        }
        return res.toString();
    }

    public static ComplexNumber createPartedNumber(IntegerFraction factor, Vector<Tupel<SymbolNumber, IntegerNumber>> parts) {
        ComplexNumber result;
        if (factor.equals(IntegerNumber.ZERO)) {
            result = IntegerNumber.ZERO;
        } else {
            IntegerNumber exponent;
            SymbolNumber part;
            Collections.sort(parts, new PartedNumberPartComparator());
            Vector<Tupel<SymbolNumber, IntegerNumber>> vparts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(parts.size());
            Vector<Tupel<SymbolNumber, IntegerNumber>> dparts = new Vector<Tupel<SymbolNumber, IntegerNumber>>();
            IntegerNumber clearedRoots = IntegerNumber.ONE;
            Tupel<SymbolNumber, IntegerNumber> lastTupel = null;
            String lastSymbol = "";
            for (Tupel<SymbolNumber, IntegerNumber> tpart : parts) {
                part = tpart.getElement1();
                exponent = tpart.getElement2();
                if (exponent.equals(IntegerNumber.ZERO)) continue;
                if (part instanceof IntegerFraction) {
                    factor = (IntegerFraction)factor.multiply(part.pow(exponent));
                    continue;
                }
                if (exponent.isNegative()) {
                    exponent = exponent.negate();
                    dparts.add(new Tupel<SymbolNumber, IntegerNumber>(part, exponent));
                    continue;
                }
                if (part.toString().equals(lastSymbol)) {
                    lastTupel.setElement2((IntegerNumber)((IntegerNumber)lastTupel.getElement2()).add(exponent));
                    continue;
                }
                lastTupel = new Tupel<SymbolNumber, IntegerNumber>(part, exponent);
                vparts.add(lastTupel);
                lastSymbol = part.toString();
            }
            result = clearedRoots;
            if (vparts.size() == 1 && factor.equals(IntegerNumber.ONE) && ((IntegerNumber)((Tupel)vparts.firstElement()).getElement2()).equals(IntegerNumber.ONE)) {
                result = (ComplexNumber)((Tupel)vparts.firstElement()).getElement1();
            } else if (vparts.size() > 0) {
                Collections.sort(vparts, new PartedNumberPartComparator());
                result = (ComplexNumber)result.multiply(new PartedNumber(factor, vparts));
            } else {
                result = (ComplexNumber)result.multiply(factor);
            }
            for (Tupel<SymbolNumber, IntegerNumber> tpart : dparts) {
                part = tpart.getElement1();
                exponent = tpart.getElement2();
                result = (ComplexNumber)result.divide(part.pow(exponent));
            }
        }
        return result;
    }

    public static ComplexNumber createPartedNumber(Vector<Tupel<SymbolNumber, IntegerNumber>> parts) {
        return PartedNumber.createPartedNumber(IntegerNumber.ONE, parts);
    }

    public static ComplexNumber createPartedNumber(IntegerFraction factor, SymbolNumber part, IntegerNumber exponent) {
        Vector<Tupel<SymbolNumber, IntegerNumber>> parts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(1);
        parts.add(new Tupel<SymbolNumber, IntegerNumber>(part, exponent));
        return PartedNumber.createPartedNumber(factor, parts);
    }

    public static ComplexNumber createPartedNumber(SymbolNumber part, IntegerNumber exponent) {
        return PartedNumber.createPartedNumber(IntegerNumber.ONE, part, exponent);
    }

    @Override
    public Numeric add(Numeric numeric) {
        Numeric result;
        if (numeric instanceof SymbolNumber) {
            Vector<PartedNumber> parts = new Vector<PartedNumber>(2);
            parts.addElement(this);
            parts.addElement((PartedNumber)numeric);
            result = PartedNumberSum.createPartedNumberSum(parts);
        } else if (numeric instanceof PartedNumber) {
            boolean match;
            PartedNumber pnumeric = (PartedNumber)numeric;
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts = pnumeric.getParts();
            boolean bl = match = parts.size() == this.getParts().size();
            if (match) {
                for (int i = 0; i < this.getParts().size(); ++i) {
                    SymbolNumber base = this.getParts().elementAt(i).getElement1();
                    IntegerNumber ex = this.getParts().elementAt(i).getElement2();
                    SymbolNumber base2 = parts.elementAt(i).getElement1();
                    IntegerNumber ex2 = parts.elementAt(i).getElement2();
                    if (base.equals(base2) && ex.equals(ex2)) continue;
                    match = false;
                    break;
                }
            }
            if (match) {
                IntegerFraction newFactor = (IntegerFraction)this.getFactor().add(pnumeric.getFactor());
                result = PartedNumber.createPartedNumber(newFactor, this.getParts());
            } else {
                Vector<PartedNumber> sumparts = new Vector<PartedNumber>(2);
                sumparts.addElement(this);
                sumparts.addElement((PartedNumber)numeric);
                result = PartedNumberSum.createPartedNumberSum(sumparts);
            }
        } else {
            result = numeric.add(this);
        }
        return result;
    }

    @Override
    public Numeric sub(Numeric numeric) {
        return this.add(numeric.negate());
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerFraction) {
            IntegerFraction newFactor = (IntegerFraction)this.getFactor().multiply(numeric);
            result = new PartedNumber(newFactor, this.getParts());
        } else if (numeric instanceof SymbolNumber) {
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts = this.getParts();
            Vector<Tupel<SymbolNumber, IntegerNumber>> newParts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(parts.size() + 1);
            newParts.addAll(parts);
            newParts.addElement(new Tupel<SymbolNumber, IntegerNumber>((SymbolNumber)numeric, IntegerNumber.ONE));
            result = PartedNumber.createPartedNumber(this.getFactor(), newParts);
        } else if (numeric instanceof PartedNumber) {
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts = this.getParts();
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts2 = ((PartedNumber)numeric).getParts();
            Vector<Tupel<SymbolNumber, IntegerNumber>> newParts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(parts.size() + parts2.size());
            newParts.addAll(parts);
            newParts.addAll(parts2);
            result = PartedNumber.createPartedNumber((IntegerFraction)this.getFactor().multiply(((PartedNumber)numeric).getFactor()), newParts);
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    @Override
    public Vector<PartedNumber> getSumParts() {
        Vector<PartedNumber> v = new Vector<PartedNumber>();
        v.addElement(this);
        return v;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerFraction) {
            IntegerFraction newFactor = (IntegerFraction)this.getFactor().divide(numeric);
            result = PartedNumber.createPartedNumber(newFactor, this.getParts());
        } else if (numeric instanceof SymbolNumber) {
            Vector<Tupel<SymbolNumber, IntegerNumber>> newParts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(this.parts.size());
            boolean consumed = false;
            for (int i = 0; i < this.parts.size(); ++i) {
                Tupel<SymbolNumber, IntegerNumber> part = this.parts.elementAt(i);
                SymbolNumber base = part.getElement1();
                if (base.toString().equals(numeric.toString())) {
                    IntegerNumber ex = (IntegerNumber)this.parts.elementAt(i).getElement2().sub(IntegerNumber.ONE);
                    if (!ex.equals(IntegerNumber.ZERO)) {
                        newParts.addElement(new Tupel<SymbolNumber, IntegerNumber>(base, ex));
                    }
                    consumed = true;
                    continue;
                }
                newParts.addElement(part);
            }
            result = !consumed ? PartedFraction.createFraction(this, (SymbolNumber)numeric) : (newParts.size() == 0 ? this.getFactor() : PartedNumber.createPartedNumber(this.factor, newParts));
        } else if (numeric instanceof PartedNumber) {
            Vector<Tupel<SymbolNumber, IntegerNumber>> newPartsNum = new Vector<Tupel<SymbolNumber, IntegerNumber>>(this.parts.size());
            Vector<Tupel<SymbolNumber, IntegerNumber>> newPartsDen = new Vector<Tupel<SymbolNumber, IntegerNumber>>();
            PartedNumber pnumeric = (PartedNumber)numeric;
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts = pnumeric.getParts();
            result = IntegerNumber.ZERO;
            int i = 0;
            int j = 0;
            while (i < this.parts.size() || j < parts.size()) {
                if (i >= this.parts.size()) {
                    newPartsDen.addElement(parts.elementAt(j));
                    ++j;
                    continue;
                }
                if (j >= parts.size()) {
                    newPartsNum.addElement(this.parts.elementAt(i));
                    ++i;
                    continue;
                }
                SymbolNumber base = this.parts.elementAt(i).getElement1();
                IntegerNumber ex = this.parts.elementAt(i).getElement2();
                SymbolNumber base2 = parts.elementAt(j).getElement1();
                IntegerNumber ex2 = parts.elementAt(j).getElement2();
                int basec = base.toString().compareTo(base2.toString());
                if (basec < 0) {
                    newPartsNum.addElement(this.parts.elementAt(i));
                    ++i;
                    continue;
                }
                if (basec > 0) {
                    newPartsDen.addElement(parts.elementAt(j));
                    ++j;
                    continue;
                }
                int exc = ex.compareTo(ex2);
                if (exc > 0) {
                    newPartsNum.addElement(new Tupel<SymbolNumber, IntegerNumber>(base, (IntegerNumber)ex.sub(ex2)));
                } else if (exc < 0) {
                    newPartsDen.addElement(new Tupel<SymbolNumber, IntegerNumber>(base, (IntegerNumber)ex2.sub(ex)));
                }
                ++i;
                ++j;
            }
            IntegerFraction newFactor = (IntegerFraction)this.factor.divide(pnumeric.factor);
            result = newPartsDen.size() == 0 ? PartedNumber.createPartedNumber(newFactor, newPartsNum) : PartedFraction.createFraction((PartedNumber)PartedNumber.createPartedNumber(newFactor.getNumerator(), newPartsNum), (PartedNumber)PartedNumber.createPartedNumber(newFactor.getDenominator(), newPartsDen));
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public Numeric ggT(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerFraction) {
            result = this.getFactor().ggT(numeric);
        } else if (numeric instanceof SymbolNumber) {
            result = IntegerNumber.ONE;
            for (int i = 0; i < this.parts.size(); ++i) {
                SymbolNumber base = this.parts.elementAt(i).getElement1();
                if (!base.toString().equals(numeric.toString())) continue;
                result = numeric;
                break;
            }
        } else if (numeric instanceof PartedNumber) {
            Vector<Tupel<SymbolNumber, IntegerNumber>> newPartsNum = new Vector<Tupel<SymbolNumber, IntegerNumber>>(this.parts.size());
            PartedNumber pnumeric = (PartedNumber)numeric;
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts = pnumeric.getParts();
            result = IntegerNumber.ZERO;
            int i = 0;
            for (int j = 0; i < this.parts.size() && j < parts.size(); ++i, ++j) {
                SymbolNumber base = this.parts.elementAt(i).getElement1();
                IntegerNumber ex = this.parts.elementAt(i).getElement2();
                SymbolNumber base2 = parts.elementAt(j).getElement1();
                IntegerNumber ex2 = parts.elementAt(j).getElement2();
                int basec = base.toString().compareTo(base2.toString());
                if (basec != 0) continue;
                int exc = ex.compareTo(ex2);
                if (exc >= 0) {
                    newPartsNum.addElement(new Tupel<SymbolNumber, IntegerNumber>(base, ex2));
                    continue;
                }
                if (exc >= 0) continue;
                newPartsNum.addElement(new Tupel<SymbolNumber, IntegerNumber>(base, ex));
            }
            IntegerFraction newFactor = (IntegerFraction)this.factor.ggT(pnumeric.factor);
            result = PartedNumber.createPartedNumber(newFactor, newPartsNum);
        } else {
            result = numeric.ggT(this);
        }
        return result;
    }

    @Override
    public PartedNumber negate() {
        return new PartedNumber(this.getFactor().negate(), this.getParts());
    }

    @Override
    public PartedFraction reciprocal() {
        return PartedFraction.createFraction(IntegerNumber.ONE, this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Numeric modulo(Numeric numeric) {
        void var2_10;
        PartedNumber partedNumber = this;
        if (numeric instanceof IntegerFraction) {
            IntegerFraction newFactor = (IntegerFraction)this.getFactor().modulo(numeric);
            ComplexNumber complexNumber = PartedNumber.createPartedNumber(newFactor, this.getParts());
            return var2_10;
        }
        if (numeric instanceof SymbolNumber) {
            int i = 0;
            while (i < this.parts.size()) {
                SymbolNumber base = this.parts.elementAt(i).getElement1();
                if (base.toString().equals(numeric.toString())) {
                    IntegerNumber integerNumber = IntegerNumber.ZERO;
                    return var2_10;
                }
                ++i;
            }
            return var2_10;
        }
        if (!(numeric instanceof PartedNumber)) return var2_10;
        PartedNumber pnumeric = (PartedNumber)numeric;
        Vector<Tupel<SymbolNumber, IntegerNumber>> parts = pnumeric.getParts();
        IntegerNumber integerNumber = IntegerNumber.ZERO;
        int i = 0;
        int j = 0;
        while (true) {
            if (i >= this.parts.size()) {
                if (j >= parts.size()) return var2_10;
            }
            if (j >= parts.size()) {
                return var2_10;
            }
            if (i >= this.parts.size()) {
                PartedNumber partedNumber2 = this;
                return var2_10;
            }
            SymbolNumber base = this.parts.elementAt(i).getElement1();
            IntegerNumber ex = this.parts.elementAt(i).getElement2();
            SymbolNumber base2 = parts.elementAt(j).getElement1();
            IntegerNumber ex2 = parts.elementAt(j).getElement2();
            if (base.toString().equals(base2.toString())) {
                if (ex.compareTo(ex2) < 0) {
                    PartedNumber partedNumber3 = this;
                    return var2_10;
                }
                ++j;
            } else if (base.toString().compareTo(base2.toString()) > 0) {
                PartedNumber partedNumber4 = this;
                return var2_10;
            }
            ++i;
        }
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o.getClass() == PartedNumber.class && ((PartedNumber)o).getFactor().equals(this.factor)) {
            result = true;
            for (int i = 0; i < this.parts.size(); ++i) {
                if (this.parts.elementAt(i).equals(((PartedNumber)o).getParts().elementAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public int compareTo(Numeric o) {
        int comp = 0;
        return comp;
    }

    @Override
    public boolean isNegative() {
        return this.getFactor().isNegative();
    }

    @Override
    public boolean isPositive() {
        return this.getFactor().isPositive();
    }

    @Override
    public ComplexNumber pow(IntegerFraction exponent) {
        ComplexNumber result;
        if (exponent instanceof IntegerNumber) {
            IntegerFraction newFactor = (IntegerFraction)this.getFactor().pow(exponent);
            Vector<Tupel<SymbolNumber, IntegerNumber>> parts = this.getParts();
            Vector<Tupel<SymbolNumber, IntegerNumber>> newParts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(parts.size());
            for (Tupel<SymbolNumber, IntegerNumber> part : parts) {
                newParts.addElement(new Tupel<SymbolNumber, IntegerNumber>(part.getElement1(), (IntegerNumber)part.getElement2().multiply(exponent)));
            }
            result = PartedNumber.createPartedNumber(newFactor, newParts);
        } else {
            result = ComplexNumber.createComplexNumber(this, exponent.negate());
        }
        return result;
    }

    @Override
    public PartedNumber abs() {
        return new PartedNumber(this.getFactor().abs(), this.getParts());
    }

    public IntegerFraction getFactor() {
        return this.factor;
    }

    public Vector<Tupel<SymbolNumber, IntegerNumber>> getParts() {
        return (Vector)this.parts.clone();
    }

    public IntegerNumber getExponentOf(SymbolNumber symbol) {
        IntegerNumber result = IntegerNumber.ZERO;
        Vector<Tupel<SymbolNumber, IntegerNumber>> parts = this.getParts();
        for (int i = 0; i < parts.size(); ++i) {
            if (!parts.elementAt(i).getElement1().equals(symbol)) continue;
            result = parts.elementAt(i).getElement2();
        }
        return result;
    }

    @Override
    public Numeric solveEqual(Numeric numeric, SymbolNumber by) {
        Numeric divided = null;
        IntegerNumber exp = this.getExponentOf(by);
        if (!exp.equals(IntegerNumber.ZERO)) {
            divided = this.divide(PartedNumber.createPartedNumber(by, exp));
        }
        if (numeric instanceof IntegerFraction) {
            if (divided != null) {
                return numeric.divide(divided).pow(exp.reciprocal());
            }
            return by;
        }
        if (numeric instanceof RootNumber) {
            return this.pow(((RootNumber)numeric).getRoot()).solveEqual(((RootNumber)numeric).getBase(), by);
        }
        if (numeric instanceof SymbolNumber) {
            if (numeric.equals(by)) {
                if (divided == null) {
                    return this;
                }
                if (exp.equals(IntegerNumber.ONE)) {
                    return divided.solveEqual(IntegerNumber.ONE, by);
                }
                return divided.pow((IntegerFraction)IntegerNumber.ONE.sub(exp));
            }
            if (divided != null) {
                return numeric.divide(divided).pow(exp);
            }
            return this.divide(numeric).solveEqual(IntegerNumber.ONE, by);
        }
        if (numeric instanceof PartedNumber) {
            Numeric divided2 = null;
            IntegerNumber exp2 = ((PartedNumber)numeric).getExponentOf(by);
            if (!exp2.equals(IntegerNumber.ZERO)) {
                divided2 = numeric.divide(PartedNumber.createPartedNumber(by, exp2));
            }
            if (divided2 != null) {
                if (divided != null) {
                    if (exp.compareTo(exp2) == 0) {
                        return divided.solveEqual(divided2, by);
                    }
                    if (exp.compareTo(exp2) > 0) {
                        return divided2.divide(divided).pow((IntegerFraction)exp.sub(exp2).reciprocal());
                    }
                    return divided.divide(divided2).pow((IntegerFraction)exp2.sub(exp).reciprocal());
                }
                return this.divide(divided2).pow(exp2.reciprocal());
            }
            if (divided != null) {
                return numeric.divide(divided).pow(exp.reciprocal());
            }
            SymbolNumber firstSym = this.parts.firstElement().getElement1();
            return this.divide(firstSym).solveEqual(numeric.divide(firstSym), by);
        }
        return numeric.solveEqual(this, by);
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        this.factor.traverseTopDown(visitor);
        for (Tupel<SymbolNumber, IntegerNumber> part : this.parts) {
            part.getElement1().traverseTopDown(visitor);
            part.getElement2().traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        this.factor.traverseBottomUp(visitor);
        for (Tupel<SymbolNumber, IntegerNumber> part : this.parts) {
            part.getElement1().traverseBottomUp(visitor);
            part.getElement2().traverseBottomUp(visitor);
        }
        visitor.visit(this);
    }
}

