/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import org.ktde.math.number.ComplexNumber;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedNumberSum;

public class PartedFraction
extends ComplexNumber {
    private PartedNumberSum numerator;
    private PartedNumberSum denominator;

    protected PartedFraction(String tostring) {
        super(tostring);
    }

    private PartedFraction(PartedNumberSum numerator, PartedNumberSum denominator) {
        super(numerator.toString() + "/" + denominator.toString());
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static PartedFraction createFraction(PartedNumberSum numerator, PartedNumberSum denominator) {
        if (denominator instanceof IntegerFraction) {
            return (PartedNumberSum)numerator.divide(denominator);
        }
        if (numerator instanceof IntegerFraction) {
            if (denominator.equals(IntegerNumber.ZERO)) {
                throw new ArithmeticException("Division by zero");
            }
            return new PartedFraction(numerator.getNumerator(), (PartedNumberSum)denominator.multiply(numerator.getDenominator()));
        }
        if (numerator.equals(denominator)) {
            return IntegerNumber.ONE;
        }
        boolean neg = numerator.isNegative() ? denominator.isPositive() : denominator.isNegative();
        PartedNumberSum ggt = (PartedNumberSum)(numerator = numerator.abs()).ggT(denominator = denominator.abs());
        if (!ggt.equals(IntegerNumber.ONE)) {
            denominator = (PartedNumberSum)denominator.divide(ggt);
            numerator = (PartedNumberSum)numerator.divide(ggt);
        }
        if (neg) {
            numerator = numerator.negate();
        }
        if (denominator.equals(IntegerNumber.ONE)) {
            return numerator;
        }
        return new PartedFraction(numerator, denominator);
    }

    @Override
    public PartedFraction getReal() {
        return this;
    }

    @Override
    public PartedFraction getImaginary() {
        return IntegerNumber.ZERO;
    }

    public PartedNumberSum getNumerator() {
        return this.numerator;
    }

    public PartedNumberSum getDenominator() {
        return this.denominator;
    }

    @Override
    public Numeric add(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            PartedNumberSum newDenominator = (PartedNumberSum)this.getDenominator().multiply(((PartedFraction)numeric).getDenominator());
            PartedNumberSum newNumerator = (PartedNumberSum)this.getNumerator().multiply(((PartedFraction)numeric).getDenominator()).add(((PartedFraction)numeric).getNumerator().multiply(this.getDenominator()));
            result = PartedFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.add(this);
        }
        return result;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            PartedNumberSum newDenominator = (PartedNumberSum)this.getDenominator().multiply(((PartedFraction)numeric).getNumerator());
            PartedNumberSum newNumerator = (PartedNumberSum)this.getNumerator().multiply(((PartedFraction)numeric).getDenominator());
            result = PartedFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        return null;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            PartedNumberSum newNumerator = (PartedNumberSum)this.getNumerator().multiply(((PartedFraction)numeric).getNumerator());
            PartedNumberSum newDenominator = (PartedNumberSum)this.getDenominator().multiply(((PartedFraction)numeric).getDenominator());
            result = PartedFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    @Override
    public PartedFraction negate() {
        return new PartedFraction(this.getNumerator().negate(), this.getDenominator());
    }

    @Override
    public PartedFraction reciprocal() {
        return PartedFraction.createFraction(this.getDenominator(), this.getNumerator());
    }

    @Override
    public Numeric sub(Numeric numeric) {
        return this.add(numeric.negate());
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == PartedFraction.class && ((PartedFraction)o).numerator.equals(this.getNumerator()) && ((PartedFraction)o).denominator.equals(this.getDenominator());
    }

    public boolean isNegative() {
        return this.getNumerator().isNegative() ^ this.getDenominator().isNegative();
    }

    public boolean isPositive() {
        return this.getNumerator().isNegative() == this.getDenominator().isNegative();
    }

    @Override
    public PartedFraction abs() {
        if (this.isNegative()) {
            return this.negate();
        }
        return this;
    }

    @Override
    public ComplexNumber pow(IntegerFraction exponent) {
        return (ComplexNumber)this.numerator.pow(exponent).divide(this.denominator.pow(exponent));
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        this.numerator.traverseTopDown(visitor);
        this.denominator.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        this.numerator.traverseTopDown(visitor);
        this.denominator.traverseTopDown(visitor);
        visitor.visit(this);
    }
}

