/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.util.Arrays;
import org.ktde.math.number.ComplexNumber;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.SymbolNumber;

public class Matrix
implements Numeric {
    private ComplexNumber[][] values;
    public static final boolean DEBUG_TABLEAU = false;

    protected Matrix(ComplexNumber[][] values) {
        this.values = new ComplexNumber[values.length][];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = (ComplexNumber[])values[i].clone();
        }
    }

    public static Matrix createMatrix(ComplexNumber[][] values) {
        return new Matrix(values);
    }

    public static Matrix createZeroMatrix(int rows, int cols) {
        ComplexNumber[][] newMatrix;
        for (Object[] objectArray : newMatrix = new ComplexNumber[cols][rows]) {
            Arrays.fill(objectArray, IntegerNumber.ZERO);
        }
        return Matrix.createMatrix(newMatrix);
    }

    public static Matrix createIdentityMatrix(int cols) {
        ComplexNumber[][] newMatrix = new ComplexNumber[cols][cols];
        for (int i = 0; i < newMatrix.length; ++i) {
            Arrays.fill(newMatrix[i], IntegerNumber.ZERO);
            newMatrix[i][i] = IntegerNumber.ONE;
        }
        return Matrix.createMatrix(newMatrix);
    }

    @Override
    public Numeric abs() {
        Matrix clone = Matrix.createMatrix(this.values);
        for (int i = 0; i < clone.values.length; ++i) {
            for (int j = 0; j < clone.values[i].length; ++j) {
                clone.values[i][j] = clone.values[i][j].abs();
            }
        }
        return clone;
    }

    @Override
    public Numeric add(Numeric numeric) {
        if (numeric instanceof Matrix) {
            Matrix clone = Matrix.createMatrix(this.values);
            Matrix mnum = (Matrix)numeric;
            for (int i = 0; i < clone.values.length; ++i) {
                for (int j = 0; j < clone.values[i].length; ++j) {
                    clone.values[i][j] = (ComplexNumber)clone.values[i][j].add(mnum.values[i][j]);
                }
            }
            return clone;
        }
        throw new ArithmeticException("cannot add " + numeric.getClass().getName() + " to matrix");
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Matrix clone;
        if (numeric instanceof ComplexNumber) {
            clone = Matrix.createMatrix(this.values);
            for (int i = 0; i < clone.values.length; ++i) {
                for (int j = 0; j < clone.values[i].length; ++j) {
                    clone.values[i][j] = (ComplexNumber)clone.values[i][j].divide(numeric);
                }
            }
        } else if (numeric instanceof Matrix) {
            int j;
            int i;
            Matrix a = Matrix.createMatrix(((Matrix)numeric).values);
            Matrix b = Matrix.createMatrix(this.values);
            int lines = a.values[0].length;
            int maxlines = Math.min(lines, a.values.length);
            int cols = b.values[0].length;
            for (i = 0; i < maxlines; ++i) {
                int j2;
                if (a.values[i][i].equals(IntegerNumber.ZERO)) {
                    ComplexNumber swap;
                    int s;
                    for (s = i + 1; s < a.values.length && a.values[s][i].equals(IntegerNumber.ZERO); ++s) {
                    }
                    if (s >= a.values.length) continue;
                    for (j2 = 0; j2 < lines; ++j2) {
                        swap = a.values[i][j2];
                        a.values[i][j2] = a.values[s][j2];
                        a.values[s][j2] = swap;
                    }
                    for (j2 = 0; j2 < cols; ++j2) {
                        swap = b.values[i][j2];
                        b.values[i][j2] = b.values[s][j2];
                        b.values[s][j2] = swap;
                    }
                }
                for (j = i + 1; j < lines; ++j) {
                    a.values[i][j] = (ComplexNumber)a.values[i][j].divide(a.values[i][i]);
                }
                for (j = 0; j < cols; ++j) {
                    b.values[i][j] = (ComplexNumber)b.values[i][j].divide(a.values[i][i]);
                }
                a.values[i][i] = IntegerNumber.ONE;
                for (int k = i + 1; k < a.values.length; ++k) {
                    if (a.values[k][i].equals(IntegerNumber.ZERO)) continue;
                    for (j2 = i + 1; j2 < lines; ++j2) {
                        a.values[k][j2] = (ComplexNumber)a.values[k][j2].sub(a.values[k][i].multiply(a.values[i][j2]));
                    }
                    for (j2 = 0; j2 < cols; ++j2) {
                        b.values[k][j2] = (ComplexNumber)b.values[k][j2].sub(a.values[k][i].multiply(b.values[i][j2]));
                    }
                    a.values[k][i] = IntegerNumber.ZERO;
                }
            }
            if (a.values.length > a.values[0].length) {
                throw new RuntimeException("not implemented: more lines than cols");
            }
            if (a.values.length < a.values[0].length) {
                throw new RuntimeException("not implemented: less lines than cols");
            }
            for (i = lines - 2; i >= 0; --i) {
                for (j = 0; j < cols; ++j) {
                    for (int k = i + 1; k < lines; ++k) {
                        b.values[i][j] = (ComplexNumber)b.values[i][j].sub(b.values[k][j].multiply(a.values[i][k]));
                    }
                }
            }
            clone = b;
        } else {
            throw new ArithmeticException("cannot divide matrix by " + numeric.getClass().getName());
        }
        return clone;
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        return null;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Matrix clone;
        if (numeric instanceof ComplexNumber) {
            clone = Matrix.createMatrix(this.values);
            for (int i = 0; i < clone.values.length; ++i) {
                for (int j = 0; j < clone.values[i].length; ++j) {
                    clone.values[i][j] = (ComplexNumber)clone.values[i][j].multiply(numeric);
                }
            }
        } else if (numeric instanceof Matrix) {
            ComplexNumber[][] newMatrix;
            Matrix mnum = (Matrix)numeric;
            clone = Matrix.createZeroMatrix(this.values.length, mnum.values[0].length);
            for (Object[] objectArray : newMatrix = clone.values) {
                Arrays.fill(objectArray, IntegerNumber.ZERO);
            }
            for (int i = 0; i < this.values.length; ++i) {
                for (int j = 0; j < mnum.values[0].length; ++j) {
                    for (int k = 0; k < this.values[0].length; ++k) {
                        newMatrix[i][j] = (ComplexNumber)newMatrix[i][j].add(this.values[i][k].multiply(mnum.values[k][j]));
                    }
                }
            }
        } else {
            throw new ArithmeticException("cannot mult " + numeric.getClass().getName() + " with matrix");
        }
        return clone;
    }

    @Override
    public Numeric negate() {
        Matrix clone = Matrix.createMatrix(this.values);
        for (int i = 0; i < clone.values.length; ++i) {
            for (int j = 0; j < clone.values[i].length; ++j) {
                clone.values[i][j] = clone.values[i][j].negate();
            }
        }
        return clone;
    }

    @Override
    public Matrix reciprocal() {
        Matrix ident = Matrix.createIdentityMatrix(this.values.length);
        return (Matrix)ident.divide(this);
    }

    @Override
    public Numeric sub(Numeric numeric) {
        if (numeric instanceof Matrix) {
            Matrix clone = Matrix.createMatrix(this.values);
            Matrix mnum = (Matrix)numeric;
            for (int i = 0; i < clone.values.length; ++i) {
                for (int j = 0; j < clone.values[i].length; ++j) {
                    clone.values[i][j] = (ComplexNumber)clone.values[i][j].sub(mnum.values[i][j]);
                }
            }
            return clone;
        }
        throw new ArithmeticException("cannot add " + numeric.getClass().getName() + " to matrix");
    }

    public ComplexNumber getDeterminant() {
        ComplexNumber result = IntegerNumber.ZERO;
        int lines = this.values.length;
        if (lines == this.values[0].length) {
            result = IntegerNumber.ONE;
            Matrix a = Matrix.createMatrix(this.values);
            for (int i = 0; i < lines; ++i) {
                int j;
                if (a.values[i][i].equals(IntegerNumber.ZERO)) {
                    int s;
                    for (s = i + 1; s < a.values.length && a.values[s][i].equals(IntegerNumber.ZERO); ++s) {
                    }
                    if (s < a.values.length) {
                        for (j = 0; j < lines; ++j) {
                            ComplexNumber swap = a.values[i][j];
                            a.values[i][j] = a.values[s][j];
                            a.values[s][j] = swap;
                        }
                        result = result.negate();
                    } else {
                        result = IntegerNumber.ZERO;
                        break;
                    }
                }
                result = (ComplexNumber)result.multiply(a.values[i][i]);
                for (int k = i + 1; k < a.values.length; ++k) {
                    if (a.values[k][i].equals(IntegerNumber.ZERO)) continue;
                    for (j = i + 1; j < lines; ++j) {
                        a.values[k][j] = (ComplexNumber)a.values[k][j].sub(a.values[k][i].multiply(a.values[i][j]).divide(a.values[i][i]));
                    }
                    a.values[k][i] = IntegerNumber.ZERO;
                }
            }
        }
        return result;
    }

    public ComplexNumber getTrace() {
        ComplexNumber result = IntegerNumber.ZERO;
        int lines = Math.min(this.values.length, this.values[0].length);
        for (int i = 0; i < lines; ++i) {
            result = (ComplexNumber)((ComplexNumber)result).add(this.values[i][i]);
        }
        return result;
    }

    public Matrix getAdjoint() {
        ComplexNumber[][] values = new ComplexNumber[this.values[0].length][this.values.length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                values[i][j] = this.values[j][i].getConjugate();
            }
        }
        return new Matrix(values);
    }

    public Matrix getTransposed() {
        ComplexNumber[][] values = new ComplexNumber[this.values[0].length][this.values.length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                values[i][j] = this.values[j][i];
            }
        }
        return new Matrix(values);
    }

    public Matrix getComplementary() {
        ComplexNumber[][] values = new ComplexNumber[this.values.length][this.values[0].length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                values[i][j] = this.getCofactor(i, j);
            }
        }
        return new Matrix(values);
    }

    public ComplexNumber getCofactor(int row, int col) {
        ComplexNumber cofactor = this.getMinor(row, col);
        if (row + col % 2 == 1) {
            cofactor = cofactor.negate();
        }
        return cofactor;
    }

    public ComplexNumber getMinor(int row, int col) {
        ComplexNumber[][] values = new ComplexNumber[this.values.length - 1][this.values[0].length - 1];
        int in = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i == row) continue;
            int jn = 0;
            for (int j = 0; j < values[0].length; ++j) {
                if (j == col) continue;
                values[in][jn] = this.values[i][j];
                ++jn;
            }
            ++in;
        }
        return new Matrix(values).getTransposed().getDeterminant();
    }

    public String[] toLines() {
        Object[] lines = new String[this.values.length];
        Arrays.fill(lines, "");
        int[] pads = new int[this.values[0].length];
        int maxpad = 0;
        String[][] strings = new String[this.values.length][this.values[0].length];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                strings[i][j] = this.values[i][j].toString();
                pads[j] = Math.max(strings[i][j].length(), pads[j]);
                maxpad = Math.max(maxpad, pads[j]);
            }
        }
        char[] spaces = new char[maxpad + 1];
        Arrays.fill(spaces, ' ');
        String padder = new String(spaces);
        int j = 1;
        while (j < this.values[0].length) {
            int n = j++;
            pads[n] = pads[n] + 1;
        }
        for (int i = 0; i < this.values.length; ++i) {
            for (int j2 = 0; j2 < this.values[i].length; ++j2) {
                String padding = padder.substring(0, pads[j2] - strings[i][j2].length());
                int n = i;
                lines[n] = (String)lines[n] + padding;
                int n2 = i;
                lines[n2] = (String)lines[n2] + strings[i][j2];
            }
        }
        return lines;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String[] lines = this.toLines();
        for (int i = 0; i < this.values.length; ++i) {
            if (i == 0) {
                result.append("/");
            } else if (i == this.values.length - 1) {
                result.append("\\");
            } else {
                result.append("|");
            }
            result.append(lines[i]);
            if (i == 0) {
                result.append("\\\n");
                continue;
            }
            if (i == this.values.length - 1) {
                result.append("/");
                continue;
            }
            result.append("|\n");
        }
        return result.toString();
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        ComplexNumber[][] complexNumberArray = this.values;
        int n = complexNumberArray.length;
        for (int i = 0; i < n; ++i) {
            ComplexNumber[] value;
            for (ComplexNumber element : value = complexNumberArray[i]) {
                element.traverseTopDown(visitor);
            }
        }
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        ComplexNumber[][] complexNumberArray = this.values;
        int n = complexNumberArray.length;
        for (int i = 0; i < n; ++i) {
            ComplexNumber[] value;
            for (ComplexNumber element : value = complexNumberArray[i]) {
                element.traverseBottomUp(visitor);
            }
        }
        visitor.visit(this);
    }

    @Override
    public Numeric ggT(Numeric numeric) {
        return null;
    }

    @Override
    public Numeric pow(IntegerFraction numeric) {
        return null;
    }

    @Override
    public Numeric solveEqual(Numeric fraction, SymbolNumber by) {
        return null;
    }

    public int getHeight() {
        return this.values.length;
    }

    public int getWidth() {
        return this.values[0].length;
    }

    public ComplexNumber getComponentAt(int row, int col) {
        return this.values[row][col];
    }
}

