/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.math.BigDecimal;
import org.ktde.math.number.ComparableNumeric;
import org.ktde.math.number.ComplexNumber;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedFraction;
import org.ktde.math.number.RootNumber;
import org.ktde.math.number.SymbolNumber;

public class IntegerFraction
extends RootNumber {
    private IntegerNumber denominator;
    private IntegerNumber numerator;

    public static IntegerFraction createFraction(double d) {
        boolean neg = d < 0.0;
        d = Math.abs(d);
        long ipart = (long)d;
        double fracpart = d - Math.floor(d);
        long num = (long)(fracpart *= 1.0E7);
        long den = 10000000L;
        IntegerNumber a = IntegerNumber.createIntegerNumber(ipart);
        IntegerNumber b = IntegerNumber.createIntegerNumber(num);
        IntegerNumber c = IntegerNumber.createIntegerNumber(den);
        IntegerFraction result = (IntegerFraction)a.add(b.divide(c));
        if (neg) {
            result = result.negate();
        }
        return result;
    }

    public static IntegerFraction createFraction(IntegerNumber numerator, IntegerNumber denominator) {
        if (numerator.equals(denominator)) {
            return IntegerNumber.ONE;
        }
        if (denominator.equals(IntegerNumber.ZERO)) {
            throw new ArithmeticException("Division by zero");
        }
        boolean neg = numerator.isNegative() ? denominator.isPositive() : denominator.isNegative();
        IntegerNumber ggt = (IntegerNumber)(numerator = numerator.abs()).ggT(denominator = denominator.abs());
        if (!ggt.equals(IntegerNumber.ONE)) {
            denominator = (IntegerNumber)denominator.divide(ggt);
            numerator = (IntegerNumber)numerator.divide(ggt);
        }
        if (neg) {
            numerator = numerator.negate();
        }
        if (denominator.equals(IntegerNumber.ONE)) {
            return numerator;
        }
        return new IntegerFraction(numerator, denominator);
    }

    protected IntegerFraction(String tostring) {
        super(tostring);
    }

    private IntegerFraction(IntegerNumber numerator, IntegerNumber denominator) {
        super(numerator.toString() + "/" + denominator.toString());
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Override
    public IntegerFraction abs() {
        if (this.isNegative()) {
            return this.negate();
        }
        return this;
    }

    @Override
    public Numeric add(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerNumber) {
            IntegerNumber newNumerator = (IntegerNumber)this.numerator.add(this.denominator.multiply(numeric));
            result = IntegerFraction.createFraction(newNumerator, this.denominator);
        } else if (numeric instanceof IntegerFraction) {
            IntegerNumber newDenominator = (IntegerNumber)this.denominator.multiply(((IntegerFraction)numeric).denominator);
            IntegerNumber newNumerator = (IntegerNumber)this.numerator.multiply(((IntegerFraction)numeric).denominator).add(((IntegerFraction)numeric).numerator.multiply(this.denominator));
            result = IntegerFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.add(this);
        }
        return result;
    }

    @Override
    public int compareTo(ComparableNumeric o) {
        int comp = 0;
        if (o instanceof IntegerNumber) {
            comp = this.numerator.compareTo(o.multiply(this.denominator));
        } else if (o instanceof IntegerFraction) {
            comp = ((IntegerFraction)this.numerator.multiply(((IntegerFraction)o).denominator)).compareTo(((IntegerFraction)o).numerator.multiply(this.denominator));
        } else if (o instanceof ComparableNumeric) {
            comp = -o.compareTo(this);
        }
        return comp;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerNumber) {
            IntegerNumber newDenominator = (IntegerNumber)this.denominator.multiply(numeric);
            result = IntegerFraction.createFraction(this.numerator, newDenominator);
        } else if (numeric instanceof IntegerFraction) {
            IntegerNumber newDenominator = (IntegerNumber)this.denominator.multiply(((IntegerFraction)numeric).numerator);
            IntegerNumber newNumerator = (IntegerNumber)this.numerator.multiply(((IntegerFraction)numeric).denominator);
            result = IntegerFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o.getClass() == IntegerFraction.class) {
            result = ((IntegerFraction)o).numerator.equals(this.numerator) && ((IntegerFraction)o).denominator.equals(this.denominator);
        }
        return result;
    }

    @Override
    public IntegerNumber getDenominator() {
        return this.denominator;
    }

    @Override
    public IntegerNumber getNumerator() {
        return this.numerator;
    }

    @Override
    public boolean isNegative() {
        return this.numerator.isNegative() ^ this.denominator.isNegative();
    }

    @Override
    public boolean isPositive() {
        return this.numerator.isNegative() == this.denominator.isNegative();
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerFraction) {
            IntegerNumber numerator = (IntegerNumber)this.getNumerator().multiply(((IntegerFraction)numeric).getDenominator()).modulo(((IntegerFraction)numeric).getNumerator().multiply(this.getDenominator()));
            IntegerNumber denominator = (IntegerNumber)((IntegerFraction)numeric).getDenominator().multiply(this.getDenominator());
            result = numerator.divide(denominator);
        } else {
            result = this;
        }
        return result;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerNumber) {
            IntegerNumber newNumerator = (IntegerNumber)this.numerator.multiply(numeric);
            result = IntegerFraction.createFraction(newNumerator, this.denominator);
        } else if (numeric instanceof IntegerFraction) {
            IntegerNumber newNumerator = (IntegerNumber)this.numerator.multiply(((IntegerFraction)numeric).numerator);
            IntegerNumber newDenominator = (IntegerNumber)this.denominator.multiply(((IntegerFraction)numeric).denominator);
            result = IntegerFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    @Override
    public IntegerFraction negate() {
        return new IntegerFraction(this.numerator.negate(), this.denominator);
    }

    @Override
    public ComplexNumber pow(IntegerFraction exponent) {
        ComplexNumber result = (ComplexNumber)this.numerator.pow(exponent).divide(this.denominator.pow(exponent));
        return result;
    }

    @Override
    public IntegerFraction reciprocal() {
        return IntegerFraction.createFraction(this.denominator, this.numerator);
    }

    @Override
    public Numeric sub(Numeric numeric) {
        return this.add(numeric.negate());
    }

    public IntegerFraction roundToGrid(IntegerFraction b) {
        IntegerNumber bd;
        IntegerNumber be;
        if (b == IntegerNumber.ZERO) {
            throw new ArithmeticException("Kann nicht auf Raster 0 runden!");
        }
        if (b.isNegative()) {
            throw new ArithmeticException("Kann nicht auf negatives Raster runden!");
        }
        IntegerNumber ae = this.numerator.abs();
        IntegerNumber ad = this.denominator;
        boolean neg = this.isNegative();
        if (b instanceof IntegerNumber) {
            be = (IntegerNumber)b;
            bd = IntegerNumber.ONE;
        } else {
            be = b.numerator.abs();
            bd = b.denominator;
        }
        IntegerNumber gcd = (IntegerNumber)ad.ggT(bd);
        IntegerNumber adg = (IntegerNumber)ad.divide(gcd);
        IntegerNumber bdg = (IntegerNumber)bd.divide(gcd);
        IntegerNumber rd = (IntegerNumber)adg.multiply(bd);
        IntegerNumber re1 = (IntegerNumber)bdg.multiply(ae);
        IntegerNumber re2 = (IntegerNumber)adg.multiply(be);
        IntegerNumber mod = (IntegerNumber)re1.modulo(re2);
        re1 = neg == ((IntegerNumber)mod.multiply(IntegerNumber.TWO)).isLessThan(re2) ? (IntegerNumber)re1.add(re2.sub(mod)) : (IntegerNumber)re1.sub(mod);
        IntegerFraction result = IntegerFraction.createFraction(neg ? re1.negate() : re1, rd);
        return result;
    }

    public String sortString() {
        return "0";
    }

    @Override
    public PartedFraction getBase() {
        return this;
    }

    @Override
    public IntegerNumber getRoot() {
        return IntegerNumber.ONE;
    }

    @Override
    public Numeric solveEqual(Numeric numeric, SymbolNumber by) {
        if (numeric instanceof IntegerFraction) {
            if (this.equals(numeric)) {
                return by;
            }
            throw new IllegalArgumentException("cannot solve " + this + "=" + numeric + " by " + by);
        }
        return numeric.solveEqual(this, by);
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        this.numerator.traverseTopDown(visitor);
        this.denominator.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        this.numerator.traverseTopDown(visitor);
        this.denominator.traverseTopDown(visitor);
        visitor.visit(this);
    }

    @Override
    public Numeric ggT(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerNumber) {
            result = this.getNumerator().ggT(numeric);
        } else if (numeric instanceof IntegerFraction) {
            IntegerNumber newNumerator = (IntegerNumber)this.numerator.multiply(((IntegerFraction)numeric).numerator);
            IntegerNumber newDenominator = (IntegerNumber)this.denominator.multiply(((IntegerFraction)numeric).denominator);
            result = IntegerFraction.createFraction(newNumerator, newDenominator);
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    public BigDecimal asBigDecimal() {
        BigDecimal n = this.numerator.asBigDecimal();
        BigDecimal d = this.denominator.asBigDecimal();
        int scale = Math.max(n.scale(), d.scale());
        return n.divide(d, scale, 4);
    }
}

