/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Iterator;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractSpanningTree;
import org.ktde.util.datatypes.SimplePriorityQueue;
import org.ktde.util.datatypes.UnionFind;

public class KruskalSpanningTree
extends AbstractSpanningTree {
    public KruskalSpanningTree(Graph graph, int costIndexEdge) {
        super(graph, costIndexEdge);
    }

    @Override
    public void reset(Graph g) {
        super.reset(g);
        this.resultGraph.addNodes(this.graph);
    }

    @Override
    protected void perform() {
        UnionFind union = new UnionFind();
        SimplePriorityQueue queue = new SimplePriorityQueue();
        Iterator<Edge<?>> iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge<?> e = iterator.next();
            queue.insertElement(e, e.getCostAt(this.costIndexEdge));
        }
        while (queue.hasNext()) {
            Edge edge = (Edge)queue.next();
            edge.setValueAt(0, 1);
            this.finishStep();
            Node<?> a = edge.getStart();
            Node<?> b = edge.getTarget();
            if (union.sameUnion(a, b)) {
                edge.setValueAt(0, 2);
                continue;
            }
            edge.setValueAt(0, 3);
            this.resultGraph.addEdge(edge);
            union.union(a, b);
        }
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getEdgeCount();
    }
}

