/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.EulerianTourFinder;

public class HierholzerEulerianTourFinder
extends EulerianTourFinder {
    public HierholzerEulerianTourFinder(Graph graph) {
        super(graph);
    }

    @Override
    protected void perform() {
        ArrayList curCircle;
        this.tour = new Vector();
        int countNode = this.graph.getNodeCount();
        int countEdge = this.graph.getEdgeCount();
        if (countEdge == 0) {
            return;
        }
        Hashtable circleHash = new Hashtable(countNode);
        Hashtable degrees = new Hashtable(countNode);
        Iterator<Node<?>> iterator = this.graph.getNodeIterator();
        while (iterator.hasNext()) {
            Node<?> n = iterator.next();
            circleHash.put(n, new ArrayList());
            degrees.put(n, this.graph.getEdgeCount(n));
        }
        Hashtable edges = new Hashtable(countEdge);
        Iterator<Edge<?>> iterator2 = this.graph.getEdgeIterator();
        while (iterator2.hasNext()) {
            Edge<?> e = iterator2.next();
            edges.put(e, true);
        }
        ArrayList<ArrayList> circles = new ArrayList<ArrayList>();
        int c = 0;
        while (countEdge > 0) {
            Edge<?> curEdge = (Edge)edges.keys().nextElement();
            curCircle = new ArrayList();
            circles.add(curCircle);
            Node<?> startNode = curEdge.getStart();
            startNode.setValueAt(0, 4);
            Node<?> curNode = curEdge.getTarget();
            Node<?> beforeNode = null;
            while (beforeNode != startNode) {
                ((List)circleHash.get(curNode)).add(c);
                beforeNode = curNode;
                edges.remove(curEdge);
                curCircle.add(curEdge);
                curEdge.assertValueCount(1);
                curEdge.setValueAt(0, c + 3);
                curNode.assertValueCount(1);
                curNode.setValueAt(0, 3);
                int degree = (Integer)degrees.get(curNode);
                if (degree == 1) {
                    throw new IllegalArgumentException("every nodes degree must be even");
                }
                if (degree == 2) {
                    degrees.remove(curNode);
                } else {
                    degrees.put(curNode, degree - 2);
                }
                int orDegree = this.graph.getOutEdgeCount(curNode);
                for (int i = 0; i < orDegree; ++i) {
                    Edge<?> e = this.graph.getEdgeAt(curNode, i);
                    if (!edges.containsKey(e)) continue;
                    curEdge = e;
                    curNode = e.getOther(curNode);
                    break;
                }
                this.finishStep();
                beforeNode.setValueAt(0, 0);
                --countEdge;
            }
            ++c;
        }
        if (c == 1) {
            for (Edge edge : (ArrayList)circles.get(0)) {
                this.tour.add(edge);
                edge.setValueAt(0, 0);
                edge.getStart().setValueAt(0, 1);
                edge.getTarget().setValueAt(0, 1);
                this.finishStep();
            }
        } else {
            boolean[] inserted = new boolean[c - 1];
            curCircle = (ArrayList)circles.get(0);
            Node<?> curNode = ((Edge)curCircle.get(0)).getStart();
            for (int i = 0; i < curCircle.size(); ++i) {
                Edge edge = (Edge)curCircle.get(i);
                edge.setValueAt(0, 0);
                edge.getStart().setValueAt(0, 1);
                edge.getTarget().setValueAt(0, 1);
                this.tour.add(edge);
                curNode = edge.getOther(curNode);
                List attached = (List)circleHash.get(curNode);
                if (attached.size() > 1) {
                    for (Integer a : attached) {
                        if (a <= 0 || inserted[a - 1]) continue;
                        inserted[a.intValue() - 1] = true;
                        ArrayList ic = (ArrayList)circles.get(a);
                        Node<?> n = ((Edge)ic.get(0)).getStart();
                        int j = 0;
                        int icsize = ic.size();
                        for (j = 0; j < icsize && n != curNode; ++j) {
                            n = ((Edge)ic.get(j)).getOther(n);
                        }
                        if (j > 0) {
                            ArrayList ic2 = new ArrayList(icsize);
                            for (int k = 0; k < icsize; ++k) {
                                ic2.add(ic.get((k + j) % icsize));
                            }
                            ic = ic2;
                        }
                        curCircle.addAll(i + 1, ic);
                    }
                }
                this.finishStep();
            }
        }
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getEdgeCount() * 2;
    }
}

