/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.ExtendedEdge;
import org.ktde.math.graph.ExtendedNode;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractGraphAlgorithm;

public class GhostNodeSymmetryConversion
extends AbstractGraphAlgorithm {
    private Graph ghostGraph;
    private Hashtable<Node<?>, Vector<ExtendedNode>> ghostNodes;
    private Hashtable<Edge<?>, Vector<ExtendedEdge>> ghostEdges;

    public GhostNodeSymmetryConversion(Graph graph) {
        super(graph);
    }

    @Override
    protected void perform() {
        this.ghostGraph = new Graph();
        this.ghostNodes = new Hashtable();
        this.ghostEdges = new Hashtable();
        Iterator<Object> iterator = this.graph.getNodeIterator();
        while (iterator.hasNext()) {
            Node<?> node = iterator.next();
            ExtendedNode nodeGhost = new ExtendedNode(node, false, false);
            this.ghostGraph.addNode(node);
            this.ghostGraph.addNode(nodeGhost);
            this.ghostGraph.addEdge(new Edge<Object>(null, node, nodeGhost, false, new double[]{0.0}));
            this.finishStep();
            Vector<ExtendedNode> nodeGhostVector = new Vector<ExtendedNode>();
            nodeGhostVector.addElement(nodeGhost);
            this.ghostNodes.put(node, nodeGhostVector);
        }
        iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (edge.isDirected()) {
                Node<?> start = edge.getStart();
                Node<?> target = edge.getTarget();
                ExtendedNode startGhost = this.ghostNodes.get(start).firstElement();
                ExtendedNode targetGhost = this.ghostNodes.get(target).firstElement();
                ExtendedEdge edgeGhost1 = new ExtendedEdge(start, targetGhost, false, edge, true, true);
                ExtendedEdge edgeGhost2 = new ExtendedEdge(startGhost, target, false, edge, true, true);
                this.ghostGraph.addEdge(edgeGhost1);
                this.ghostGraph.addEdge(edgeGhost2);
                Vector<ExtendedEdge> edgeGhostVector = new Vector<ExtendedEdge>();
                edgeGhostVector.addElement(edgeGhost1);
                edgeGhostVector.addElement(edgeGhost2);
                this.ghostEdges.put(edge, edgeGhostVector);
            } else {
                this.ghostGraph.addEdge(edge);
            }
            this.finishStep();
        }
    }

    public Hashtable<Edge<?>, Vector<ExtendedEdge>> getGhostEdges() {
        return this.ghostEdges;
    }

    public Hashtable<Node<?>, Vector<ExtendedNode>> getGhostNodes() {
        return this.ghostNodes;
    }

    public Graph getSymmetricGraph() {
        this.start(false);
        return this.ghostGraph;
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getNodeCount() + this.graph.getEdgeCount();
    }
}

