/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractMatching;
import org.ktde.math.graph.algo.AlternatingTreeFinder;
import org.ktde.util.datatypes.Tupel;

public class AlternatingTreeMatching
extends AbstractMatching {
    public AlternatingTreeMatching(Graph graph) {
        super(graph);
    }

    @Override
    public void reset(Graph g) {
        super.reset(g);
        this.resultGraph.addNodes(this.graph);
    }

    @Override
    protected void perform() {
        AlternatingTreeFinder finder = new AlternatingTreeFinder(this.graph);
        boolean stop = false;
        int roundRobin = 0;
        int count = this.graph.getEdgeCount();
        Vector edges = new Vector(count);
        Iterator<Edge<?>> iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge<?> e = iterator.next();
            edges.add(e);
        }
        while (!stop) {
            stop = true;
            Tupel<Graph, Vector<Node<?>>> altTreeTupel = null;
            for (int i = 0; i < count; ++i) {
                Edge e = (Edge)edges.elementAt(roundRobin++);
                if (roundRobin % count == 0) {
                    roundRobin = 0;
                }
                altTreeTupel = finder.findTree(this.resultGraph, e);
                e.assertValueCount(1);
                e.setValueAt(0, 3);
                if (altTreeTupel.getElement2().isEmpty()) continue;
                stop = false;
                break;
            }
            if (stop) continue;
            Node<?> node = (Node<?>)((Vector)altTreeTupel.getElement2()).firstElement();
            Graph tree = (Graph)altTreeTupel.getElement1();
            Iterator<Object> iterator2 = this.graph.getNodeIterator();
            while (iterator2.hasNext()) {
                Node<?> node2 = iterator2.next();
                if (this.resultGraph.existsNode(node2)) {
                    if (tree.existsNode(node2)) {
                        node2.setValueAt(0, 2);
                        continue;
                    }
                    node2.setValueAt(0, 4);
                    continue;
                }
                if (tree.existsNode(node2)) {
                    node2.setValueAt(0, 6);
                    continue;
                }
                node2.setValueAt(0, 0);
            }
            iterator2 = this.graph.getEdgeIterator();
            while (iterator2.hasNext()) {
                Edge edge2 = (Edge)iterator2.next();
                edge2.assertValueCount(1);
                if (this.resultGraph.existsEdge(edge2)) {
                    if (tree.existsEdge(edge2)) {
                        edge2.setValueAt(0, 2);
                        continue;
                    }
                    edge2.setValueAt(0, 4);
                    continue;
                }
                if (tree.existsEdge(edge2)) {
                    edge2.setValueAt(0, 1);
                    continue;
                }
                edge2.setValueAt(0, 0);
            }
            this.finishStep();
            Hashtable way = new Hashtable();
            boolean state = false;
            way.put(node, Boolean.TRUE);
            while (node != null) {
                int edgecount = tree.getEdgeCount(node);
                Node<?> cur = node;
                node = null;
                for (int i = 0; i < edgecount; ++i) {
                    Edge<?> e = tree.getEdgeAt(cur, i);
                    if (state != this.resultGraph.existsEdge(e) || way.containsKey(node = e.getOther(cur))) continue;
                    way.put(node, Boolean.TRUE);
                    if (!state) {
                        e.setValueAt(0, 3);
                        this.resultGraph.addEdge(e);
                    } else {
                        e.setValueAt(0, 0);
                        this.resultGraph.removeEdge(e);
                    }
                    node.setValueAt(0, 8);
                    e.setValueAt(0, state ? 7 : 8);
                    break;
                }
                state = !state;
            }
            this.finishStep();
        }
        iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge<?> edge2 = iterator.next();
            if (this.resultGraph.existsEdge(edge2)) {
                edge2.setValueAt(0, 3);
                continue;
            }
            edge2.setValueAt(0, 0);
        }
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getNodeCount() * 2;
    }
}

