/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Node<T> {
    protected T associatedObject;
    protected int[] values;
    protected double[] cost;

    public Node() {
        this(null, new double[]{0.0}, new int[0]);
    }

    public Node(double[] cost) {
        this(null, cost, new int[0]);
    }

    public Node(double[] cost, int countValues) {
        this(null, cost, new int[countValues]);
    }

    public Node(double[] cost, int[] values) {
        this(null, cost, values);
    }

    public Node(T associatedObject) {
        this(associatedObject, new double[]{0.0}, new int[0]);
    }

    public Node(T associatedObject, double[] cost) {
        this(associatedObject, cost, new int[0]);
    }

    public Node(T associatedObject, double[] cost, int countValues) {
        this(associatedObject, cost, new int[countValues]);
    }

    public Node(T associatedObject, double[] cost, int[] values) {
        this.associatedObject = associatedObject;
        this.cost = cost;
        this.values = values;
    }

    public int getValueAt(int index) {
        return this.values[index];
    }

    public void setValueAt(int index, int value) {
        this.values[index] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertValueCount(int count) {
        if (this.values.length < count) {
            Node node = this;
            synchronized (node) {
                int[] newValues = new int[count];
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.values = newValues;
            }
        }
    }

    public double getCostAt(int index) {
        return this.cost[index];
    }

    public void setCostAt(int index, double cost) {
        this.cost[index] = cost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCostCount(int count) {
        if (this.cost.length < count) {
            Node node = this;
            synchronized (node) {
                double[] newCost = new double[count];
                System.arraycopy(this.cost, 0, newCost, 0, this.cost.length);
                this.cost = newCost;
            }
        }
    }

    public T getAssociatedObject() {
        return this.associatedObject;
    }

    public void setAssociatedObject(T associatedObject) {
        this.associatedObject = associatedObject;
    }

    public String toString() {
        return this.associatedObject == null ? "" + this.hashCode() : this.associatedObject.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.associatedObject).toHashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Node) {
            Node node = (Node)obj;
            return new EqualsBuilder().append(this.associatedObject, node.associatedObject).isEquals();
        }
        return result;
    }
}

