/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Node;

public class Graph {
    Hashtable<Node<?>, List<Edge<?>>> incomingEdges = new Hashtable();
    Hashtable<Node<?>, List<Edge<?>>> outgoingEdges = new Hashtable();
    Hashtable<Node<?>, List<Edge<?>>> incidentEdges = new Hashtable();
    Hashtable<Edge<?>, Edge<?>> edgeHash = new Hashtable();

    public boolean existsNode(Node<?> node) {
        return this.incidentEdges.containsKey(node);
    }

    public boolean existsEdge(Edge<?> edge) {
        return this.edgeHash.containsKey(edge);
    }

    public int getEdgeCount(Node<?> node) {
        try {
            return this.incidentEdges.get(node).size();
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException("Node doesn't exist");
        }
    }

    public Edge<?> getEdgeAt(Node<?> node, int index) {
        try {
            return this.incidentEdges.get(node).get(index);
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException("Node doesn't exist");
        }
    }

    public int getInEdgeCount(Node<?> node) {
        try {
            return this.incomingEdges.get(node).size();
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException("Node doesn't exist");
        }
    }

    public Edge<?> getInEdgeAt(Node<?> node, int index) {
        try {
            return this.incomingEdges.get(node).get(index);
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException("Node doesn't exist");
        }
    }

    public int getOutEdgeCount(Node<?> node) {
        try {
            return this.outgoingEdges.get(node).size();
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException("Node doesn't exist");
        }
    }

    public Edge<?> getOutEdgeAt(Node<?> node, int index) {
        try {
            return this.outgoingEdges.get(node).get(index);
        }
        catch (NullPointerException npe) {
            throw new NoSuchElementException("Node doesn't exist");
        }
    }

    public void addEdge(Edge<?> edge) {
        this.addEdgeQuiet(edge);
    }

    protected void addEdgeQuiet(Edge<?> edge) {
        if (!this.existsEdge(edge)) {
            this.edgeHash.put(edge, edge);
            Node<?> start = edge.getStart();
            Node<?> target = edge.getTarget();
            this.addNodeQuiet(start);
            this.addNodeQuiet(target);
            if (edge.isDirected()) {
                this.outgoingEdges.get(start).add(edge);
                this.incomingEdges.get(target).add(edge);
            } else {
                this.incomingEdges.get(start).add(edge);
                this.outgoingEdges.get(start).add(edge);
                if (start != target) {
                    this.incomingEdges.get(target).add(edge);
                    this.outgoingEdges.get(target).add(edge);
                }
            }
            this.incidentEdges.get(start).add(edge);
            if (start != target) {
                this.incidentEdges.get(target).add(edge);
            }
        }
    }

    public void removeEdge(Edge<?> edge) {
        this.removeEdgeQuiet(edge);
    }

    protected void removeEdgeQuiet(Edge<?> edge) {
        if (this.existsEdge(edge)) {
            this.edgeHash.remove(edge);
            this.incomingEdges.get(edge.getStart()).remove(edge);
            this.incomingEdges.get(edge.getTarget()).remove(edge);
            this.outgoingEdges.get(edge.getStart()).remove(edge);
            this.outgoingEdges.get(edge.getTarget()).remove(edge);
            this.incidentEdges.get(edge.getStart()).remove(edge);
            this.incidentEdges.get(edge.getTarget()).remove(edge);
        }
    }

    public void addNode(Node<?> node) {
        this.addNodeQuiet(node);
    }

    protected void addNodeQuiet(Node<?> node) {
        if (!this.existsNode(node)) {
            this.incidentEdges.put(node, new ArrayList());
            this.incomingEdges.put(node, new ArrayList());
            this.outgoingEdges.put(node, new ArrayList());
        }
    }

    public void removeNode(Node<?> node) {
        this.removeNodeQuiet(node);
    }

    protected void removeNodeQuiet(Node<?> node) {
        if (this.existsNode(node)) {
            List<Edge<?>> edges = this.incidentEdges.get(node);
            for (Edge<?> edge : edges) {
                this.removeEdgeQuiet(edge);
            }
        }
    }

    public Iterator<Edge<?>> getEdgeIterator() {
        return this.edgeHash.keySet().iterator();
    }

    public Iterator<Node<?>> getNodeIterator() {
        return this.incidentEdges.keySet().iterator();
    }

    public int getNodeCount() {
        return this.incidentEdges.size();
    }

    public int getEdgeCount() {
        return this.edgeHash.size();
    }

    public void addNodes(Graph graph) {
        Iterator<Node<?>> iterator = graph.getNodeIterator();
        while (iterator.hasNext()) {
            this.addNodeQuiet(iterator.next());
        }
    }

    public void addEdges(Graph graph) {
        Iterator<Edge<?>> iterator = graph.getEdgeIterator();
        while (iterator.hasNext()) {
            this.addEdgeQuiet(iterator.next());
        }
    }

    public boolean areConnected(Node<?> n1, Node<?> n2) {
        boolean result = false;
        if (this.existsNode(n1) && this.existsNode(n2)) {
            for (Edge<?> edge : this.incidentEdges.get(n1)) {
                if (!edge.getOther(n1).equals(n2)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Graph getNodeSet() {
        Graph g = new Graph();
        g.addNodes(this);
        return g;
    }
}

