/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.types.doubletype;

import java.util.ArrayList;
import java.util.List;
import org.ktde.math.geom.types.Linestring;
import org.ktde.math.geom.types.Point;

public class SegmentedPolygon
extends org.ktde.math.geom.types.SegmentedPolygon<Double> {
    public SegmentedPolygon(List<Linestring<Double>> list) {
        super(list);
    }

    public static SegmentedPolygon createInstance(List<?> list) {
        if (list.isEmpty()) {
            return new SegmentedPolygon((List<Linestring<Double>>)new ArrayList<Linestring<Double>>());
        }
        if (list.get(0) instanceof Linestring) {
            return SegmentedPolygon.createInstanceFromLines(list);
        }
        return SegmentedPolygon.createInstanceFromPoints(list);
    }

    public static SegmentedPolygon createInstanceFromLines(List<? extends Linestring<Double>> lines) {
        ArrayList<Linestring<Double>> result = new ArrayList<Linestring<Double>>();
        for (Linestring<Double> linestring : lines) {
            result.add(linestring);
        }
        return new SegmentedPolygon((List<Linestring<Double>>)result);
    }

    public static SegmentedPolygon createInstanceFromPoints(List<List<? extends Point<Double>>> points) {
        ArrayList<org.ktde.math.geom.types.doubletype.Linestring> lines = new ArrayList<org.ktde.math.geom.types.doubletype.Linestring>();
        for (List<? extends Point<Double>> subpoints : points) {
            lines.add(org.ktde.math.geom.types.doubletype.Linestring.createInstance(subpoints));
        }
        return SegmentedPolygon.createInstanceFromLines(lines);
    }

    @Override
    public boolean ccw(Double p1x, Double p1y, Double p2x, Double p2y, Double p3x, Double p3y) {
        double dy2;
        double dx2;
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        return dy1 * (dx2 = p3x - p2x) < (dy2 = p3y - p2y) * dx1;
    }

    @Override
    public boolean isDirected() {
        double area = 0.0;
        for (int i = 1; i < this.getPointCount() + 1; ++i) {
            double x1 = (Double)this.getPointAt(i - 1).getX();
            double y1 = (Double)this.getPointAt(i - 1).getY();
            double x2 = (Double)this.getPointAt(i % this.getPointCount()).getX();
            double y2 = (Double)this.getPointAt(i % this.getPointCount()).getY();
            double change = x1 * y2 - x2 * y1;
            area += change;
        }
        return area > 0.0;
    }
}

