/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.types;

import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ktde.math.geom.types.Point;

public abstract class Polygon<T> {
    private List<Point<T>> points;

    public Polygon(List<Point<T>> points) {
        this.points = points;
    }

    public Point<T> getPointAt(int index) {
        return this.points.get(index);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public boolean checkComplex() {
        int j;
        int i = 0;
        for (j = i + 2; j < this.getPointCount() - 1; ++j) {
            if (!this.intersect(i, j)) continue;
            return true;
        }
        for (i = 1; i < this.getPointCount(); ++i) {
            for (j = i + 2; j < this.getPointCount(); ++j) {
                if (!this.intersect(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersect(int i1, int i2) {
        int s1 = i1 > 0 ? i1 - 1 : this.getPointCount() - 1;
        int s2 = i2 > 0 ? i2 - 1 : this.getPointCount() - 1;
        Point<T> ps1 = this.getPointAt(s1);
        Point<T> ps2 = this.getPointAt(s2);
        Point<T> pi1 = this.getPointAt(i1);
        Point<T> pi2 = this.getPointAt(i2);
        boolean result = this.ccw(ps1.getX(), ps1.getY(), pi1.getX(), pi1.getY(), ps2.getX(), ps2.getY()) != this.ccw(ps1.getX(), ps1.getY(), pi1.getX(), pi1.getY(), pi2.getX(), pi2.getY()) && this.ccw(ps2.getX(), ps2.getY(), pi2.getX(), pi2.getY(), ps1.getX(), ps1.getY()) != this.ccw(ps2.getX(), ps2.getY(), pi2.getX(), pi2.getY(), pi1.getX(), pi1.getY());
        return result;
    }

    protected abstract boolean ccw(T var1, T var2, T var3, T var4, T var5, T var6);

    public abstract boolean isDirected();

    public boolean isValid() {
        return this.isDirected() && this.checkComplex();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        for (int i = 0; i < this.getPointCount(); ++i) {
            toStringBuilder.append("POINT(" + i + ")", this.getPointAt(i));
        }
        return toStringBuilder.toString();
    }
}

