/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.types;

import java.util.ArrayList;
import java.util.List;
import org.ktde.math.geom.types.Point;

public abstract class Linestring<T> {
    private List<Point<T>> points;

    public Linestring(List<Point<T>> points) {
        this.points = points;
    }

    public Point<T> getPointAt(int index) {
        return this.points.get(index);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point<T> getFirstPoint() {
        return this.points.get(0);
    }

    public Point<T> getLastPoint() {
        return this.points.get(this.points.size() - 1);
    }

    public abstract Linestring<?> newInstance(List<? extends Point<?>> var1);

    public Linestring<?> unshift(Point<T> p) {
        ArrayList<Point<T>> clone = new ArrayList<Point<T>>();
        clone.add(p);
        clone.addAll(this.points);
        return this.newInstance(clone);
    }

    public Linestring<?> replaceFirst(Point<T> p) {
        ArrayList<Point<T>> clone = new ArrayList<Point<T>>();
        clone.addAll(this.points);
        clone.set(0, p);
        return this.newInstance(clone);
    }

    public List<Point<T>> getPointsAsList() {
        ArrayList<Point<T>> clone = new ArrayList<Point<T>>(this.points.size());
        clone.addAll(this.points);
        return clone;
    }
}

