/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.algorithm.sand;

import java.util.ArrayList;
import java.util.List;
import org.ktde.math.geom.algorithm.sand.AngleSectPoint;
import org.ktde.math.geom.algorithm.sand.polyshrink.ShrinkingPoint;
import org.ktde.math.geom.types.Linestring;
import org.ktde.math.geom.types.Point;
import org.ktde.math.geom.types.doubletype.MutablePoint;
import org.ktde.math.geom.types.doubletype.SegmentedPolygon;
import org.ktde.math.helper.ComputeTrigonometrics;
import org.ktde.util.ListHelper;

public class PolyShrinkAlgorithm {
    public static SegmentedPolygon buildBuffers(SegmentedPolygon poly, double step, double size, boolean createPoints) {
        SegmentedPolygon nextpoly;
        if (!poly.isDirected()) {
            return null;
        }
        SegmentedPolygon outer = PolyShrinkAlgorithm.convertPoly(poly, createPoints);
        double initstep = step * 0.01;
        if (createPoints) {
            nextpoly = PolyShrinkAlgorithm.shrink(outer, initstep, true);
            boolean hadIntersection = nextpoly.isValid();
            if (hadIntersection) {
                return null;
            }
        } else {
            nextpoly = outer;
        }
        SegmentedPolygon curpoly = nextpoly;
        int count = (int)(size / step);
        for (int i = 0; i < count; ++i) {
            double fac = i == 0 ? step - initstep : step;
            nextpoly = PolyShrinkAlgorithm.shrink(curpoly, fac, true);
            boolean hadIntersection = nextpoly.isValid();
            if (hadIntersection && (hadIntersection = (nextpoly = PolyShrinkAlgorithm.shrink(curpoly, fac, false)).isValid())) {
                return curpoly;
            }
            curpoly = nextpoly;
        }
        double mod = size - (double)count * step;
        if (mod > 0.0) {
            curpoly = PolyShrinkAlgorithm.shrink(curpoly, mod, false);
        }
        return curpoly;
    }

    private static int addPoints(List<ShrinkingPoint> result, Point<Double> point, Point<Double> prev, Point<Double> next, boolean createPoints) {
        double angle2;
        int count = 0;
        double x = point.getX();
        double y = point.getY();
        double x1 = prev.getX();
        double y1 = prev.getY();
        double x2 = next.getX();
        double y2 = next.getY();
        double deltax1 = x1 - x;
        double deltay1 = y1 - y;
        double deltax2 = x2 - x;
        double deltay2 = y2 - y;
        double angle1 = Math.atan2(deltay1, deltax1);
        double angle = ComputeTrigonometrics.normalizeAngle(angle1 - (angle2 = Math.atan2(deltay2, deltax2)), false);
        if (angle > Math.PI) {
            int countPoints = 2;
            if (createPoints) {
                countPoints = angle < 3.9269908169872414 ? 3 : (angle < 4.71238898038469 ? 3 : (angle < 5.497787143782138 ? 5 : (angle < Math.PI * 2 ? 5 : 5)));
            }
            double anglestep = (angle - Math.PI) / (double)(countPoints - 1);
            double curAngle = angle1 - 1.5707963267948966;
            for (int i = 0; i < countPoints; ++i) {
                ShrinkingPoint curpoint = new ShrinkingPoint(point.getX(), point.getY(), new AngleSectPoint(1.0, curAngle));
                result.add(curpoint);
                ++count;
                curAngle = ComputeTrigonometrics.normalizeAngle(curAngle - anglestep);
            }
        } else {
            while (angle1 < angle2) {
                angle1 += Math.PI * 2;
            }
            double c = 1.0 / Math.sin(angle / 2.0);
            double a = ComputeTrigonometrics.normalizeAngle((angle1 + angle2) / 2.0);
            ShrinkingPoint curpoint = new ShrinkingPoint(point.getX(), point.getY(), new AngleSectPoint(c, a));
            result.add(curpoint);
            ++count;
        }
        return count;
    }

    private static void setMax(ShrinkingPoint p1, ShrinkingPoint p2) {
        double angleb;
        double l = Math.sqrt(Math.pow((Double)p1.getX() - (Double)p2.getX(), 2.0) + Math.pow((Double)p1.getY() - (Double)p2.getY(), 2.0));
        if (l == 0.0) {
            return;
        }
        double angle = ComputeTrigonometrics.normalizeAngle(Math.atan2((Double)p2.getY() - (Double)p1.getY(), (Double)p2.getX() - (Double)p1.getX()));
        double anglea = ComputeTrigonometrics.normalizeAngle(((AngleSectPoint)p1.getFunction()).getAngle() - angle);
        if (anglea > 1.5707963267948966) {
            anglea = 1.5707963267948966;
        }
        if ((angleb = ComputeTrigonometrics.normalizeAngle(Math.PI + angle - ((AngleSectPoint)p2.getFunction()).getAngle())) > 1.5707963267948966) {
            angleb = 1.5707963267948966;
        }
        if (anglea == 1.5707963267948966 && angleb == 1.5707963267948966) {
            return;
        }
        double ta = Math.tan(anglea);
        double tb = Math.tan(angleb);
        double j = l * tb / (ta + tb);
        double s = j * ta;
        double h = s / Math.sin(angleb);
        double g = s / Math.sin(anglea);
        double he = h / l;
        double ge = g / l;
        ((AngleSectPoint)p1.getFunction()).setMax(g - ge);
        ((AngleSectPoint)p2.getFunction()).setMax(h - he);
    }

    static SegmentedPolygon convertPoly(SegmentedPolygon poly2, boolean createPoints) {
        ArrayList result = new ArrayList();
        int lineCount = poly2.getLineCount();
        for (int l = 0; l < lineCount; ++l) {
            result.add(new ArrayList());
        }
        Linestring lastline = poly2.getLinestringAt(lineCount - 1);
        for (int l = 0; l < lineCount; ++l) {
            Linestring line = poly2.getLinestringAt(l);
            int pointCount = line.getPointCount();
            List curlist = (List)result.get(l);
            MutablePoint last = (MutablePoint)lastline.getPointAt(lastline.getPointCount() - 2);
            MutablePoint cur = (MutablePoint)line.getFirstPoint();
            for (int i = 0; i < pointCount; ++i) {
                int truncate;
                MutablePoint next = i == pointCount - 1 ? (MutablePoint)poly2.getLinestringAt((l + 1) % lineCount).getPointAt(1) : (MutablePoint)line.getPointAt(i + 1);
                int multcount = PolyShrinkAlgorithm.addPoints(curlist, cur, last, next, createPoints);
                last = cur;
                if (i == 0) {
                    truncate = (multcount - 1) / 2;
                    for (int t = 0; t < truncate; ++t) {
                        curlist.remove(0);
                    }
                } else if (i == pointCount - 1) {
                    truncate = (multcount - 1) / 2;
                    int locCount = curlist.size();
                    for (int t = 0; t < truncate; ++t) {
                        curlist.remove(locCount - 1);
                        --locCount;
                    }
                }
                cur = next;
            }
            lastline = line;
        }
        SegmentedPolygon newpolygon = SegmentedPolygon.createInstance(result);
        int pointCount = newpolygon.getPointCount();
        ShrinkingPoint p1 = (ShrinkingPoint)newpolygon.getPointAt(pointCount - 1);
        for (int i = 0; i < pointCount; ++i) {
            ShrinkingPoint p2 = (ShrinkingPoint)newpolygon.getPointAt(i);
            PolyShrinkAlgorithm.setMax(p1, p2);
            p1 = p2;
        }
        return newpolygon;
    }

    private static SegmentedPolygon shrink(SegmentedPolygon poly, double fac, boolean ignoreIntersect) {
        int mode;
        ArrayList<List<ShrinkingPoint>> result = new ArrayList<List<ShrinkingPoint>>();
        int lineCount = poly.getLineCount();
        for (int l = 0; l < lineCount; ++l) {
            Linestring line = poly.getLinestringAt(l);
            ArrayList<ShrinkingPoint> points = new ArrayList<ShrinkingPoint>();
            result.add(points);
            int pointCount = line.getPointCount();
            for (int p = 1; p < pointCount; ++p) {
                points.add((ShrinkingPoint)line.getPointAt(p));
            }
        }
        int smallerInterval = 4;
        int biggerInterval = 16;
        if (lineCount >= 64) {
            smallerInterval = (int)Math.ceil((double)lineCount / 16.0);
            biggerInterval = 4 * smallerInterval;
            mode = 0;
        } else {
            mode = lineCount > 16 ? 0 : (lineCount > 4 ? 1 : 2);
        }
        List<List<Object>> savelist = ListHelper.cloneSubList(result);
        int savestart = 0;
        block7: for (int l = 0; l < lineCount; ++l) {
            List curlist = (List)result.get(l);
            ArrayList<ShrinkingPoint> clonelist = new ArrayList<ShrinkingPoint>();
            for (int i = 0; i < curlist.size(); ++i) {
                ShrinkingPoint cur = (ShrinkingPoint)curlist.get(i);
                ShrinkingPoint shrinked = cur.getShrinkedPoint(fac);
                clonelist.add(shrinked);
            }
            result.set(l, clonelist);
            if (ignoreIntersect) continue;
            switch (mode) {
                case 0: {
                    if ((l + 1) % biggerInterval != 0 && l != lineCount - 1) continue block7;
                    boolean intersects = PolyShrinkAlgorithm.isValid(result);
                    if (intersects) {
                        mode = 1;
                        result = ListHelper.cloneList(savelist);
                        l = savestart;
                        continue block7;
                    }
                    savestart = l + 1;
                    savelist = ListHelper.cloneList(result);
                    continue block7;
                }
                case 1: {
                    if ((l + 1) % smallerInterval != 0 && l != lineCount - 1) continue block7;
                    boolean intersects = PolyShrinkAlgorithm.isValid(result);
                    if (intersects) {
                        mode = 2;
                        result = ListHelper.cloneList(savelist);
                        l = savestart;
                        continue block7;
                    }
                    savestart = l + 1;
                    savelist = ListHelper.cloneList(result);
                    if ((l + 1) % biggerInterval != 0) continue block7;
                    mode = 0;
                    continue block7;
                }
                case 2: {
                    boolean intersects = PolyShrinkAlgorithm.isValid(result);
                    if (intersects) {
                        result.set(l, curlist);
                        for (int i = 0; i < curlist.size(); ++i) {
                            ShrinkingPoint cur = (ShrinkingPoint)curlist.get(i);
                            ShrinkingPoint shrinked = cur.getShrinkedPoint(fac);
                            curlist.set(i, shrinked);
                            intersects = PolyShrinkAlgorithm.isValid(result);
                            if (!intersects) continue;
                            curlist.set(i, cur);
                            cur.setBlocked(true);
                        }
                    }
                    if ((l + 1) % smallerInterval != 0) continue block7;
                    savestart = l + 1;
                    savelist = ListHelper.cloneSubList(result);
                    mode = (l + 1) % biggerInterval == 0 ? 0 : 1;
                }
            }
        }
        return SegmentedPolygon.createInstance(result);
    }

    private static boolean isValid(List<List<ShrinkingPoint>> list) {
        SegmentedPolygon poly = SegmentedPolygon.createInstance(list);
        boolean intersects = poly.isValid();
        return intersects;
    }

    public static SegmentedPolygon buildSmallerBuffers(SegmentedPolygon poly, int size) {
        ArrayList sidelist = new ArrayList();
        for (int l = 0; l < poly.getLineCount(); ++l) {
            ArrayList<ShrinkingPoint> points = new ArrayList<ShrinkingPoint>();
            Linestring line = poly.getLinestringAt(l);
            for (int i = 0; i < line.getPointCount(); ++i) {
                ShrinkingPoint shrinkingPointBounds = (ShrinkingPoint)line.getPointAt(i);
                double fac = shrinkingPointBounds.getFac();
                ShrinkingPoint shrinkingPointSide = (ShrinkingPoint)shrinkingPointBounds.clone();
                if (fac < (double)(size + 2)) {
                    if (fac > 4.0) {
                        shrinkingPointSide.setFac(fac - 2.0);
                    } else {
                        shrinkingPointSide.setFac(fac / 2.0);
                    }
                } else {
                    shrinkingPointSide.setFac(size);
                }
                points.add(shrinkingPointSide);
            }
            sidelist.add(points);
        }
        return SegmentedPolygon.createInstance(sidelist);
    }
}

