/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math;

public class MatrixHelper {
    public static double[][] getInverse(double[][] matrix) {
        double[][] target = new double[matrix.length][matrix.length];
        for (int i = 0; i < target.length; ++i) {
            target[i][i] = 1.0;
        }
        return MatrixHelper.solveLinear(matrix, target);
    }

    public static double[][] getTranspose(double[][] matrix) {
        double[][] target = new double[matrix.length][matrix.length];
        for (int i = 0; i < target.length; ++i) {
            target[i][i] = 1.0;
        }
        return MatrixHelper.solveLinear(matrix, target);
    }

    public static double[][] solveLinear(double[][] matrix, double[][] target) {
        int k;
        int j;
        int i;
        int lines = target.length;
        int cols = target[0].length;
        double[][] m = new double[lines][lines];
        double[][] res = new double[lines][cols];
        for (i = 0; i < lines; ++i) {
            for (j = 0; j < lines; ++j) {
                m[i][j] = matrix[i][j];
            }
            for (j = 0; j < cols; ++j) {
                res[i][j] = target[i][j];
            }
        }
        MatrixHelper.printLinear(matrix, target);
        for (i = 0; i < lines; ++i) {
            for (j = i + 1; j < lines; ++j) {
                m[i][j] = m[i][j] / m[i][i];
            }
            for (j = 0; j < cols; ++j) {
                res[i][j] = res[i][j] / m[i][i];
            }
            m[i][i] = 1.0;
            for (k = i + 1; k < lines; ++k) {
                int j2;
                if (m[k][i] == 0.0) continue;
                for (j2 = i + 1; j2 < lines; ++j2) {
                    double[] dArray = m[k];
                    int n = j2;
                    dArray[n] = dArray[n] - m[k][i] * m[i][j2];
                }
                for (j2 = 0; j2 < cols; ++j2) {
                    double[] dArray = res[k];
                    int n = j2;
                    dArray[n] = dArray[n] - m[k][i] * res[i][j2];
                }
                m[k][i] = 0.0;
            }
            MatrixHelper.printLinear(m, res);
        }
        for (i = lines - 2; i >= 0; --i) {
            for (j = 0; j < cols; ++j) {
                for (int k2 = i + 1; k2 < lines; ++k2) {
                    double[] dArray = res[i];
                    int n = j;
                    dArray[n] = dArray[n] - res[k2][j] * m[i][k2];
                }
            }
            for (k = i + 1; k < lines; ++k) {
                m[i][k] = 0.0;
            }
            MatrixHelper.printLinear(m, res);
        }
        return res;
    }

    public static void main(String[] args) {
        double[][] matrix = new double[][]{{1.0, 3.0, 2.0}, {3.0, 2.0, 1.0}, {2.0, 3.0, 1.0}};
        double[][] target = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        double[][] inv = MatrixHelper.solveLinear(matrix, target);
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        MatrixHelper.printMatrix(matrix);
        MatrixHelper.printMatrix(inv);
        double[][] inv2 = MatrixHelper.solveLinear(inv, target);
        MatrixHelper.printMatrix(inv2);
    }

    public static void printMatrix(double[][] matrix) {
        for (double[] element : matrix) {
            for (int j = 0; j < matrix[0].length; ++j) {
                System.out.print(element[j] + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printLinear(double[][] matrix, double[][] target) {
        for (int i = 0; i < matrix.length; ++i) {
            int j;
            for (j = 0; j < matrix[0].length; ++j) {
                System.out.print(MatrixHelper.format(matrix[i][j]) + "\t");
            }
            System.out.print("\t\t|\t\t");
            for (j = 0; j < target[0].length; ++j) {
                System.out.print(MatrixHelper.format(target[i][j]) + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static String format(double d) {
        String res = "" + d;
        while (res.length() < 5) {
            res = " " + res;
        }
        res = res.substring(0, 5);
        return res;
    }
}

