/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.spring;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class PreprocessableResource
implements Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreprocessableResource.class);
    private List<Tupel<String, String>> replacements;
    private Resource resource;

    public PreprocessableResource(Resource resource, List<Tupel<String, String>> replacements) {
        this.replacements = replacements;
        this.resource = resource;
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        return this.resource.createRelative(relativePath);
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public String getDescription() {
        return this.resource.getDescription();
    }

    @Override
    public File getFile() throws IOException {
        return this.resource.getFile();
    }

    @Override
    public String getFilename() {
        return this.resource.getFilename();
    }

    @Override
    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    @Override
    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    @Override
    public boolean isOpen() {
        return this.resource.isOpen();
    }

    @Override
    public boolean isReadable() {
        return this.resource.isReadable();
    }

    @Override
    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        LOGGER.info("Reading file resource: " + this.getFile().getCanonicalPath());
        InputStream in = this.resource.getInputStream();
        String content = IOUtils.toString(in, "UTF-8");
        for (Tupel<String, String> tupel : this.replacements) {
            content = content.replace(tupel.getElement1(), tupel.getElement2());
        }
        return new ByteArrayInputStream(content.getBytes("UTF-8"));
    }
}

