/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.spring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.ktde.util.application.ClientApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;
import org.springframework.core.io.Resource;

public class AccessiblePropertiesConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessiblePropertiesConfigurer.class);
    private static final Constants constants = new Constants(PropertyPlaceholderConfigurer.class);
    private Properties properties;
    private List<Resource> location;
    private List<Resource> optionalLocation;
    private String applicationName;
    private String fileEncoding = "UTF-8";
    private int systemPropertiesMode = 1;

    @Override
    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setLocation(List<Resource> location) {
        this.location = location;
    }

    public void setOptionalLocation(List<Resource> optionalLocation) {
        this.optionalLocation = optionalLocation;
    }

    @Override
    public void setSystemPropertiesMode(int systemPropertiesMode) {
        super.setSystemPropertiesMode(systemPropertiesMode);
        this.systemPropertiesMode = systemPropertiesMode;
    }

    @Override
    public void setSystemPropertiesModeName(String systemPropertiesMode) {
        super.setSystemPropertiesModeName(systemPropertiesMode);
        this.systemPropertiesMode = constants.asNumber(systemPropertiesMode).intValue();
    }

    @Override
    protected String resolvePlaceholder(String placeholder, Properties defaults) {
        if (this.properties == null) {
            this.initProperties(defaults);
        }
        return this.properties.getProperty(placeholder);
    }

    protected void initProperties(Properties defaults) {
        try {
            InputStream inputStream;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (Resource resource : this.location) {
                inputStream = resource.getInputStream();
                IOUtils.copy(inputStream, (OutputStream)baos);
                baos.write(10);
                IOUtils.closeQuietly(inputStream);
            }
            if (this.optionalLocation != null) {
                for (Resource resource : this.optionalLocation) {
                    if (resource.exists()) {
                        inputStream = resource.getInputStream();
                        IOUtils.copy(inputStream, (OutputStream)baos);
                        baos.write(10);
                        IOUtils.closeQuietly(inputStream);
                        continue;
                    }
                    LOGGER.info("Optional resource " + resource.getFilename() + " does not exist");
                }
            }
            baos.flush();
            baos.close();
            this.properties = ClientApplicationProperties.loadProperties(this.applicationName, new ByteArrayInputStream(baos.toByteArray()), this.fileEncoding, this.systemPropertiesMode, null, defaults);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
            this.properties = new Properties();
        }
        LOGGER.info("Using properties: " + this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public File getSpecificFile() {
        return ClientApplicationProperties.getSpecificFile(this.applicationName);
    }
}

