/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi.hessian;

import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianConnectionFactory;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.ktde.ee.rmi.hessian.HessianProxyFactory;
import org.ktde.ee.rmi.hessian.HessianURLConnection;

public class HessianURLConnectionFactory
implements HessianConnectionFactory {
    private static final Logger log = Logger.getLogger(HessianURLConnectionFactory.class.getName());
    private HessianProxyFactory _proxyFactory;
    private Properties properties;

    @Override
    public HessianConnection open(URL url) throws IOException {
        long connectTimeout;
        URLConnection conn;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " open(" + url + ")");
        }
        if ((conn = url.openConnection()) instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)conn;
            httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return hostname.equals(session.getPeerHost());
                }
            });
        }
        if ((connectTimeout = this._proxyFactory.getConnectTimeout()) >= 0L) {
            conn.setConnectTimeout((int)connectTimeout);
        }
        conn.setDoOutput(true);
        long readTimeout = this._proxyFactory.getReadTimeout();
        if (readTimeout > 0L) {
            try {
                conn.setReadTimeout((int)readTimeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HessianURLConnection(this.properties, url, conn);
    }

    @Override
    public void setHessianProxyFactory(com.caucho.hessian.client.HessianProxyFactory factory) {
        this._proxyFactory = (HessianProxyFactory)factory;
        this.properties = ((HessianProxyFactory)factory).getProperties();
    }
}

