/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi.hessian;

import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemote;
import com.caucho.services.server.AbstractSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.BindException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ktde.ee.rmi.hessian.HessianProxyFactory;
import org.ktde.ee.rmi.hessian.RetryException;

public class HessianProxy
implements InvocationHandler,
Serializable {
    private static final int RETRY_COUNT = 3;
    private static final long RETRY_GAP = 1000L;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(HessianProxy.class.getName());
    protected HessianProxyFactory _factory;
    private WeakHashMap<Method, String> _mangleMap = new WeakHashMap();
    private Class<?> _type;
    private URL _url;
    private Properties properties;

    protected HessianProxy(Properties properties, URL url, HessianProxyFactory factory) {
        this(properties, url, factory, null);
    }

    protected HessianProxy(Properties properties, URL url, HessianProxyFactory factory, Class<?> type) {
        this._factory = factory;
        this._url = url;
        this._type = type;
        this.properties = properties;
    }

    public URL getURL() {
        return this._url;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Throwable ex = null;
        String retryCountString = (String)this.properties.get("connection.retryCount");
        String retryGapString = (String)this.properties.get("connection.retryGap");
        int retryCount = 3;
        try {
            retryCount = Integer.parseInt(retryCountString);
            if (retryCount < 1) {
                retryCount = 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long retryGap = 1000L;
        try {
            retryGap = Long.parseLong(retryGapString);
            if (retryGap < 1L) {
                retryGap = 1000L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < retryCount; ++i) {
            try {
                return this.invoke2(proxy, method, args);
            }
            catch (RetryException e) {
                ex = e.getCause();
                try {
                    Thread.sleep(retryGap);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new HessianRuntimeException(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke2(Object proxy, Method method, Object[] args) throws IOException, Throwable {
        String mangleName;
        WeakHashMap<Method, String> weakHashMap = this._mangleMap;
        synchronized (weakHashMap) {
            mangleName = this._mangleMap.get(method);
        }
        if (mangleName == null) {
            String methodName = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
                Object value = args[0];
                if (value == null || !Proxy.isProxyClass(value.getClass())) {
                    return Boolean.FALSE;
                }
                InvocationHandler proxyHandler = Proxy.getInvocationHandler(value);
                if (!(proxyHandler instanceof HessianProxy)) {
                    return Boolean.FALSE;
                }
                HessianProxy handler = (HessianProxy)proxyHandler;
                return new Boolean(this._url.equals(handler.getURL()));
            }
            if (methodName.equals("hashCode") && params.length == 0) {
                return new Integer(this._url.hashCode());
            }
            if (methodName.equals("getHessianType")) {
                return proxy.getClass().getInterfaces()[0].getName();
            }
            if (methodName.equals("getHessianURL")) {
                return this._url.toString();
            }
            if (methodName.equals("toString") && params.length == 0) {
                return "HessianProxy[" + this._url + "]";
            }
            mangleName = !this._factory.isOverloadEnabled() ? method.getName() : this.mangleName(method);
            WeakHashMap<Method, String> value = this._mangleMap;
            synchronized (value) {
                this._mangleMap.put(method, mangleName);
            }
        }
        InputStream is = null;
        HessianDebugInputStream dIs = null;
        HessianConnection conn = null;
        try {
            AbstractHessianInput in;
            int code;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Hessian[" + this._url + "] calling " + mangleName);
            }
            conn = this.sendRequest(mangleName, args);
            is = conn.getInputStream();
            if (log.isLoggable(Level.FINEST)) {
                PrintWriter dbg = new PrintWriter(new LogWriter(log));
                dIs = new HessianDebugInputStream(is, dbg);
                dIs.startTop2();
                is = dIs;
            }
            if ((code = is.read()) == 72) {
                Object value;
                int major = is.read();
                int minor = is.read();
                in = this._factory.getHessian2Input(is);
                Object object = value = in.readReply(method.getReturnType());
                return object;
            }
            if (code == 114) {
                int major = is.read();
                int minor = is.read();
                in = this._factory.getHessianInput(is);
                in.startReplyBody();
                Object value = in.readObject(method.getReturnType());
                if (value instanceof InputStream) {
                    value = new ResultInputStream(conn, is, in, (InputStream)value);
                    is = null;
                    conn = null;
                } else {
                    in.completeReply();
                }
                Object object = value;
                return object;
            }
            try {
                throw new HessianProtocolException("'" + (char)code + "' is an unknown code");
            }
            catch (HessianProtocolException e) {
                throw new HessianRuntimeException(e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                if (dIs != null) {
                    dIs.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                if (conn != null) {
                    conn.destroy();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    protected String mangleName(Method method) {
        Class<?>[] param = method.getParameterTypes();
        if (param == null || param.length == 0) {
            return method.getName();
        }
        return AbstractSkeleton.mangleName(method, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HessianConnection sendRequest(String methodName, Object[] args) throws IOException {
        HessianConnection conn = null;
        conn = this._factory.getConnectionFactory().open(this._url);
        boolean isValid = false;
        try {
            this.addRequestHeaders(conn);
            OutputStream os = null;
            try {
                os = conn.getOutputStream();
            }
            catch (BindException e) {
                throw new RetryException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new HessianRuntimeException(e);
            }
            if (log.isLoggable(Level.FINEST)) {
                PrintWriter dbg = new PrintWriter(new LogWriter(log));
                HessianDebugOutputStream dOs = new HessianDebugOutputStream(os, dbg);
                dOs.startTop2();
                os = dOs;
            }
            AbstractHessianOutput out = this._factory.getHessianOutput(os);
            out.call(methodName, args);
            out.flush();
            conn.sendRequest();
            isValid = true;
            HessianConnection hessianConnection = conn;
            return hessianConnection;
        }
        finally {
            if (!isValid && conn != null) {
                conn.destroy();
            }
        }
    }

    private void addRequestHeaders(HessianConnection conn) {
        Map cookieValues;
        conn.addHeader("Content-Type", "x-application/hessian");
        String basicAuth = this._factory.getBasicAuth();
        if (basicAuth != null) {
            conn.addHeader("Authorization", basicAuth);
        }
        if ((cookieValues = (Map)this.properties.get("cookies")) != null) {
            StringBuffer cookieStringBuffer = new StringBuffer();
            for (String cookieName : cookieValues.keySet()) {
                String cookieValue = (String)cookieValues.get(cookieName);
                cookieStringBuffer.append(cookieName);
                cookieStringBuffer.append("=");
                cookieStringBuffer.append(cookieValue);
                cookieStringBuffer.append(";");
            }
            int cookieStringBufferLength = cookieStringBuffer.length();
            if (cookieStringBufferLength > 0) {
                String set = cookieStringBuffer.substring(0, cookieStringBufferLength - 1);
                conn.addHeader("Cookie", set);
            }
        }
    }

    public Object writeReplace() {
        return new HessianRemote(this._type.getName(), this._url.toString());
    }

    static {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }

    static class LogWriter
    extends Writer {
        private Logger _log;
        private Level _level = Level.FINEST;
        private StringBuilder _sb = new StringBuilder();

        LogWriter(Logger log) {
            this._log = log;
        }

        public void write(char ch) {
            if (ch == '\n' && this._sb.length() > 0) {
                this._log.fine(this._sb.toString());
                this._sb.setLength(0);
            } else {
                this._sb.append(ch);
            }
        }

        @Override
        public void write(char[] buffer, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                char ch = buffer[offset + i];
                if (ch == '\n' && this._sb.length() > 0) {
                    this._log.log(this._level, this._sb.toString());
                    this._sb.setLength(0);
                    continue;
                }
                this._sb.append(ch);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            if (this._sb.length() > 0) {
                this._log.log(this._level, this._sb.toString());
            }
        }
    }

    static class ResultInputStream
    extends InputStream {
        private HessianConnection _conn;
        private InputStream _connIs;
        private AbstractHessianInput _in;
        private InputStream _hessianIs;

        ResultInputStream(HessianConnection conn, InputStream is, AbstractHessianInput in, InputStream hessianIs) {
            this._conn = conn;
            this._connIs = is;
            this._in = in;
            this._hessianIs = hessianIs;
        }

        @Override
        public int read() throws IOException {
            if (this._hessianIs != null) {
                int value = this._hessianIs.read();
                if (value < 0) {
                    this.close();
                }
                return value;
            }
            return -1;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this._hessianIs != null) {
                int value = this._hessianIs.read(buffer, offset, length);
                if (value < 0) {
                    this.close();
                }
                return value;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            HessianConnection conn = this._conn;
            this._conn = null;
            InputStream connIs = this._connIs;
            this._connIs = null;
            AbstractHessianInput in = this._in;
            this._in = null;
            InputStream hessianIs = this._hessianIs;
            this._hessianIs = null;
            try {
                if (hessianIs != null) {
                    hessianIs.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                if (in != null) {
                    in.completeReply();
                    in.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                if (connIs != null) {
                    connIs.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }
}

