/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi.ejb;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ktde.ee.rmi.CommType;
import org.ktde.ee.rmi.ServerStub;

public class EjbCommType
implements CommType {
    private InitialContext initialContext;

    @Override
    public Object createInstance(ServerStub serverStub, Class<?> c, String url) {
        String jndiName;
        try {
            if (!url.startsWith("ejb://")) {
                throw new IllegalArgumentException("url must start with \"ejb://\": " + url);
            }
            URL urlObject = new URL("http" + url.substring(3));
            jndiName = urlObject.getPath().substring(1);
            if (this.initialContext == null) {
                Hashtable<String, String> environment = new Hashtable<String, String>();
                environment.put("org.omg.CORBA.ORBInitialHost", urlObject.getHost());
                environment.put("org.omg.CORBA.ORBInitialPort", Integer.toString(urlObject.getPort()));
                this.initialContext = new InitialContext(environment);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        try {
            return this.initialContext.lookup("java:" + jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needsUrl() {
        return true;
    }
}

