/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.WeakHashMap;
import org.ktde.util.ExceptionHandler;
import org.ktde.util.ExceptionHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceInvocationHandler.class);
    private final WeakHashMap<Method, Method> methodMap;
    private final Object delegate;
    private final Object context;
    private ExceptionHandlerFactory exceptionHandlerFactory;

    public ServiceInvocationHandler(Object delegate, ExceptionHandlerFactory exceptionHandlerFactory, Object context) {
        this.context = context;
        this.delegate = delegate;
        this.methodMap = new WeakHashMap();
        this.exceptionHandlerFactory = exceptionHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method delegateMethod;
        WeakHashMap<Method, Method> weakHashMap = this.methodMap;
        synchronized (weakHashMap) {
            delegateMethod = this.methodMap.get(method);
            if (delegateMethod == null) {
                delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
                this.methodMap.put(method, delegateMethod);
            }
        }
        LOGGER.trace("called " + method.getName());
        Object result = null;
        while (true) {
            try {
                result = delegateMethod.invoke(this.delegate, args);
            }
            catch (Throwable e) {
                while (true) {
                    if (e instanceof UndeclaredThrowableException) {
                        e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
                        continue;
                    }
                    if (!(e instanceof InvocationTargetException)) break;
                    e = ((InvocationTargetException)e).getTargetException();
                }
                ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlerFactory.getInstance(e.getClass());
                if (handler != null) continue;
                throw e;
                if (handler.handle(e, this.context)) continue;
            }
            break;
        }
        return result;
    }
}

