/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.ktde.ee.layer.AbstractMappingFactory;
import org.ktde.ee.layer.CollectionDto;
import org.ktde.ee.layer.MappingFactory;
import org.ktde.ee.rmi.CacheableDto;
import org.ktde.ee.rmi.CommType;
import org.ktde.ee.rmi.ModelManagerServiceInvocationHandler;
import org.ktde.ee.rmi.ServerStub;
import org.ktde.model.CacheableModel;
import org.ktde.model.Model;
import org.ktde.model.collections.AbstractCollectionModel;
import org.ktde.model.collections.BagModel;
import org.ktde.model.collections.ListModel;
import org.ktde.model.collections.SetModel;
import org.ktde.util.ExceptionHandlerFactory;
import org.ktde.util.cache.TwoLevelCache;
import org.ktde.util.datatypes.Bag;
import org.ktde.util.function.BooleanConstantFunction;

public class ModelManagerServerStub
extends ServerStub {
    private String url;
    private Object context;
    private CommType commType;
    private ClassLoader loader;
    private TwoLevelCache<Class<?>, Long, CacheableModel> cache;
    private Hashtable<Class<?>, Object> services;
    private Properties properties;
    private MappingFactory toModelMappingFactory;
    private MappingFactory fromModelMappingFactory;
    private ExceptionHandlerFactory exceptionHandlerFactory;

    public ModelManagerServerStub(String url, CommType commType, MappingFactory toModelMappingFactory, MappingFactory fromModelMappingFactory, ExceptionHandlerFactory exceptionHandlerFactory, Object context) {
        this(url, commType, new TwoLevelCache(), toModelMappingFactory, fromModelMappingFactory, exceptionHandlerFactory, context);
    }

    public ModelManagerServerStub(String url, CommType commType, TwoLevelCache<Class<?>, Long, CacheableModel> cache, MappingFactory toModelMappingFactory, MappingFactory fromModelMappingFactory, ExceptionHandlerFactory exceptionHandlerFactory, Object context) {
        super(url, commType, exceptionHandlerFactory, context, new Properties());
        this.url = url;
        this.context = context;
        this.commType = commType;
        this.services = new Hashtable();
        this.loader = Thread.currentThread().getContextClassLoader();
        this.cache = cache;
        this.properties = new Properties();
        this.toModelMappingFactory = toModelMappingFactory;
        this.fromModelMappingFactory = fromModelMappingFactory;
        this.exceptionHandlerFactory = exceptionHandlerFactory;
    }

    @Override
    protected CommType getCommType() {
        return this.commType;
    }

    @Override
    protected String getUrlExtension(Class<?> c, CommType commType) {
        return "";
    }

    @Override
    public synchronized <T> T getBusinessInterface(Class<T> c) {
        Object service = this.services.get(c);
        if (service == null) {
            ModelManagerServiceInvocationHandler handler = new ModelManagerServiceInvocationHandler(this.cache, this.commType.createInstance(this, c, this.url + this.getUrlExtension(c, this.commType)), this.toModelMappingFactory, this.exceptionHandlerFactory, this.context);
            service = Proxy.newProxyInstance(this.loader, new Class[]{c}, (InvocationHandler)handler);
            this.services.put(c, service);
        }
        return (T)service;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public TwoLevelCache<Class<?>, Long, CacheableModel> getCache() {
        return this.cache;
    }

    public MappingFactory getFromModelMappingFactory() {
        return this.fromModelMappingFactory;
    }

    public MappingFactory getToModelMappingFactory() {
        return this.toModelMappingFactory;
    }

    public <U extends Model, T extends CacheableDto> ListModel<U> transformList(Class<U> clazz, List<T> dtos) {
        ListModel result = new ListModel();
        this.transformCollection(clazz, dtos, result);
        return result;
    }

    public <U extends Model, T extends CacheableDto> SetModel<U> transformSet(Class<U> clazz, Set<T> dtos) {
        SetModel result = new SetModel();
        this.transformCollection(clazz, dtos, result);
        return result;
    }

    public <U extends Model, T extends CacheableDto> BagModel<U> transformBag(Class<U> clazz, Bag<T> dtos) {
        BagModel result = new BagModel();
        this.transformCollection(clazz, dtos, result);
        return result;
    }

    public <U extends Model, T extends CacheableDto> void transformCollection(Class<U> clazz, Collection<T> dtos, Collection<U> result) {
        ((AbstractCollectionModel)result).setCanAppendAnonymous(BooleanConstantFunction.TRUE);
        ((AbstractCollectionModel)result).setCanAppendObject(BooleanConstantFunction.TRUE);
        for (CacheableDto t : dtos) {
            U u = this.transformObject(clazz, t);
            result.add(u);
        }
        AbstractMappingFactory.transferFunctions((CollectionDto)dtos, (AbstractCollectionModel)result);
    }

    public <U extends Model, T extends CacheableDto> U transformObject(Class<U> clazz, T t) {
        Model u = this.getCache().getInstance(clazz, t.getId());
        return (U)u;
    }
}

