/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class FillImpl
implements Fill,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private FilterFactory filterFactory;
    private Expression color = null;
    private Expression backgroundColor = null;
    private Expression opacity = null;
    private Graphic graphicFill = null;

    protected FillImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public FillImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Expression getColor() {
        return this.color;
    }

    public void setColor(Expression rgb) {
        if (this.color == rgb) {
            return;
        }
        this.color = rgb;
    }

    public void setColor(String rgb) {
        if (this.color.toString() == rgb) {
            return;
        }
        this.setColor(this.filterFactory.literal(rgb));
    }

    public Expression getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Expression rgb) {
        if (this.backgroundColor == rgb) {
            return;
        }
        this.backgroundColor = rgb;
    }

    public void setBackgroundColor(String rgb) {
        LOGGER.fine("setting bg color with " + rgb + " as a string");
        if (this.backgroundColor.toString() == rgb) {
            return;
        }
        this.setBackgroundColor(this.filterFactory.literal(rgb));
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Expression opacity) {
        if (this.opacity == opacity) {
            return;
        }
        this.opacity = opacity;
    }

    public void setOpacity(String opacity) {
        if (this.opacity.toString() == opacity) {
            return;
        }
        this.setOpacity(this.filterFactory.literal(opacity));
    }

    public Graphic getGraphicFill() {
        return this.graphicFill;
    }

    public void setGraphicFill(org.opengis.style.Graphic graphicFill) {
        if (this.graphicFill == graphicFill) {
            return;
        }
        this.graphicFill = GraphicImpl.cast(graphicFill);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            FillImpl clone = (FillImpl)super.clone();
            if (this.graphicFill != null) {
                clone.graphicFill = (Graphic)((Cloneable)((Object)this.graphicFill)).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone FillImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.backgroundColor != null) {
            result = 1000003 * result + this.backgroundColor.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.graphicFill != null) {
            result = 1000003 * result + this.graphicFill.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FillImpl) {
            FillImpl other = (FillImpl)oth;
            return Utilities.equals(this.color, other.color) && Utilities.equals(this.backgroundColor, other.backgroundColor) && Utilities.equals(this.opacity, other.opacity) && Utilities.equals(this.graphicFill, other.graphicFill);
        }
        return false;
    }

    static FillImpl cast(org.opengis.style.Fill fill) {
        if (fill == null) {
            return null;
        }
        if (fill instanceof FillImpl) {
            return (FillImpl)fill;
        }
        FillImpl copy = new FillImpl();
        copy.color = fill.getColor();
        copy.graphicFill = GraphicImpl.cast(fill.getGraphicFill());
        copy.opacity = fill.getOpacity();
        copy.backgroundColor = null;
        return copy;
    }
}

